\name{prodcomb}
\alias{prodcomb}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Combine two time series using a time-varying linear combination.}
\description{This function takes the \code{cfs} vector and splits it
	into two halves. The first half contains the wavelet coefficients
	for the \code{alpha} linear combination function, and the second
	half for the \code{beta} one. Then the functions themselves are
	generated by using the \code{coeftofn} function. Then, the
	coefficient functions are multiplied by the respective time
	series (\code{tsx} by \code{alpha} and \code{tsy} by \code{beta})
	and the result returned.
}
\usage{
prodcomb(cfs, tsx, tsy, filter.number = 1, family = "DaubExPhase", all = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{cfs}{Wavelet coefficients of the two combination functions.
		The coefficients for alpha/beta combination functions
	are stored in the first/last half of the vector.}
  \item{tsx}{The x time series to combine}
  \item{tsy}{The y time series to combine}
  \item{filter.number}{The wavelet filter to use to obtain functions from
	coefficients}
  \item{family}{ The wavelet family to do the same.}
  \item{all}{ If TRUE then a list containing the combined series
	in the component \code{lcts} and the combination functions
	in components \code{alpha} and \code{beta}. Although the 
	combined series is the thing that is usually later tested for
	stationarity, it is often useful to see, at some stage,
	what the combination functions are, as these provide
	interpretation as to what the combination might mean.
	If FALSE then just the combined series is returned.}
}
\details{This function is called by \code{\link{findstysols}} and makes
	use of \code{\link{coeftofn}} to turn coefficients into a 
	function used in the combination.
}
\value{If \code{all=TRUE} then a list with the following components:
  \item{lcts}{The combined series, \deqn{\alpha_t X_t + \beta_t Y_t}}
  \item{alpha}{The \deqn{\alpha_t} combination function.}
  \item{beta}{The \deqn{\beta_t} combination function.}
	If \code{all=FALSE} then only \code{lcts} is returned.
}
\references{`Costationary and stationarity tests for stock index returns' by Car
dinali and Nason, 2008, University of Bristol Technical Report 08:08.}
\author{Guy Nason}
\seealso{\code{\link{findstysols}}, \code{\link{coeftofn}}}
\examples{
#
# Toy example
#
tmp.a <- c(1, -1)
tmp.b <- c(0.5, 0.5)
#
# Generate toy time series
#
xxx <- rnorm(256)
yyy <- rnorm(256)
#
# Combine xxx and yyy using the functions produced by inverse wavelet
# transform of tmp.a and tmp.b
#
\dontrun{tmp <- prodcomb(c(tmp.a, tmp.b), tsx=xxx, tsy=yyy)}
#
# E.g. plot combination
#
\dontrun{ts.plot(tmp)}
#
# Potentially test its stationarity.... etc
#
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ts}
