% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_simulation_functions.R
\name{zj_pp}
\alias{zj_pp}
\title{Simulate posterior probabilities of causality from joint Z-score vector}
\usage{
zj_pp(Zj, V, nrep = 1000, W = 0.2, Sigma)
}
\arguments{
\item{Zj}{Vector of joint Z-scores (0s except at CV)}

\item{V}{Variance of the estimated effect size (can be obtained using Var.beta.cc function)}

\item{nrep}{Number of posterior probability systems to simulate (default 1000)}

\item{W}{Prior for the standard deviation of the effect size parameter, beta (default 0.2)}

\item{Sigma}{SNP correlation matrix}
}
\value{
Matrix of simulated posterior probabilties, one simulation per row
}
\description{
Simulate nrep marginal Z-scores from joint Z-scores and convert these to posterior probabilities of causality
}
\details{
Does not include posterior probabilities for null model
}
\examples{

set.seed(1)
nsnps <- 100
Zj <- rep(0, nsnps)
iCV <- 4 # index of CV
mu <- 5 # true effect at CV
Zj[iCV] <- mu

## generate example LD matrix and MAFs
library(mvtnorm)
nsamples = 1000

simx <- function(nsnps, nsamples, S, maf=0.1) {
    mu <- rep(0,nsnps)
    rawvars <- rmvnorm(n=nsamples, mean=mu, sigma=S)
    pvars <- pnorm(rawvars)
    x <- qbinom(1-pvars, 1, maf)
}

S <- (1 - (abs(outer(1:nsnps,1:nsnps,`-`))/nsnps))^4
X <- simx(nsnps,nsamples,S)
LD <- cor2(X)
maf <- colMeans(X)

## generate V (variance of estimated effect sizes)
varbeta <- Var.data.cc(f = maf, N = 5000, s = 0.5)

res <- zj_pp(Zj, V = varbeta, nrep = 5, W = 0.2, Sigma = LD)

res[c(1:5), c(1:5)]


}
\author{
Anna Hutchinson
}
