% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.r
\name{agg_tcorpus}
\alias{agg_tcorpus}
\title{Aggregate the tokens data}
\usage{
agg_tcorpus(tc, ..., by = NULL, .id = NULL, wide = T)
}
\arguments{
\item{tc}{A tCorpus}

\item{...}{The name of the aggregated column and the function over an existing column are given as a name value pair. For example,
count = length(token) will count the number of tokens in each group, and sentiment = mean(sentiment, na.rm=T)
will calculate the mean score for a column with sentiment scores.}

\item{by}{A character vector with column names from the tokens and/or meta data.}

\item{.id}{If an id column is given, only rows for which this id is not NA are used, and only one row for each id is used.
This prevents double counting of values in annotations that span multiple rows. For example, a sentiment dictionary can match the tokens "not good", in which case
the sentiment score (-1) will be assigned to both tokens. These annotations should have an _id column that indicates the unique matches.}

\item{wide}{Should results be in wide or long format?}
}
\value{
A data table
}
\description{
This is a wrapper for the data.table aggregate function, for easy aggregation of the tokens data grouped by columns in the tokens or meta data.
The .id argument is an important addition, because token annotation often contain values that span multiple rows.
}
\examples{
\donttest{
tc = create_tcorpus(sotu_texts, doc_col='id')

library(quanteda)
dict = data_dictionary_LSD2015
dict = melt_quanteda_dict(dict)
dict$sentiment = ifelse(dict$code \%in\% c('positive','neg_negative'), 1, -1)
tc$code_dictionary(dict)

agg_tcorpus(tc, N = length(sentiment), sent = mean(sentiment), .id='code_id')
agg_tcorpus(tc, sent = mean(sentiment), .id='code_id', by='president')
agg_tcorpus(tc, sent = mean(sentiment), .id='code_id', by=c('president', 'token'))
}
}
