% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_corpora.r
\name{compare_corpus}
\alias{compare_corpus}
\title{Compare tCorpus vocabulary to that of another (reference) tCorpus}
\usage{
compare_corpus(
  tc,
  tc_y,
  feature,
  smooth = 0.1,
  min_ratio = NULL,
  min_chi2 = NULL,
  is_subset = F,
  yates_cor = c("auto", "yes", "no"),
  what = c("freq", "docfreq", "cooccurrence")
)
}
\arguments{
\item{tc}{a \code{\link{tCorpus}}}

\item{tc_y}{the reference tCorpus}

\item{feature}{the column name of the feature that is to be compared}

\item{smooth}{Laplace smoothing is used for the calculation of the probabilities. Here you can set the added (pseuocount) value.}

\item{min_ratio}{threshold for the ratio value, which is the ratio of the relative frequency of a term in dtm.x and dtm.y}

\item{min_chi2}{threshold for the chi^2 value}

\item{is_subset}{Specify whether tc is a subset of tc_y. In this case, the term frequencies of tc will be subtracted from the term frequencies in tc_y}

\item{yates_cor}{mode for using yates correctsion in the chi^2 calculation. Can be turned on ("yes") or off ("no"), or set to "auto", in which case cochrans rule is used to determine whether yates' correction is used.}

\item{what}{choose whether to compare the frequency ("freq") of terms, or the document frequency ("docfreq"). This also affects how chi^2 is calculated, comparing either freq relative to vocabulary size or docfreq relative to corpus size (N)}
}
\value{
A vocabularyComparison object
}
\description{
Compare tCorpus vocabulary to that of another (reference) tCorpus
}
\examples{
\donttest{
tc = create_tcorpus(sotu_texts, doc_column = 'id')

tc$preprocess('token', 'feature', remove_stopwords = TRUE, use_stemming = TRUE)

obama = tc$subset_meta(president == 'Barack Obama', copy=TRUE)
bush = tc$subset_meta(president == 'George W. Bush', copy=TRUE)

comp = compare_corpus(tc, bush, 'feature')
comp = comp[order(-comp$chi),]
head(comp)
plot(comp)
}
}
