% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semnet_backbone.r
\name{backbone_filter}
\alias{backbone_filter}
\title{Extract the backbone of a network.}
\usage{
backbone_filter(g, alpha = 0.05, direction = "none",
  delete_isolates = T, max_vertices = NULL, use_original_alpha = T,
  k_is_n = F)
}
\arguments{
\item{g}{A graph in the `Igraph` format.}

\item{alpha}{The threshold for the alpha. Can be interpreted similar to a p value (see paper for clarrification).}

\item{direction}{direction = 'none' can be used for both directed and undirected networks, and is (supposed to be) the disparity filter proposed in Serrano et al. (2009) is used. By setting to 'in' or 'out', the alpha is only calculated for out or in edges. This is an experimental use of the backbone extraction (so beware!) but it seems a logical application.}

\item{delete_isolates}{If TRUE, vertices with degree 0 (i.e. no edges) are deleted.}

\item{max_vertices}{Optional. Set a maximum number of vertices for the network to be produced. The alpha is then automatically lowered to the point that only the given number of vertices remains connected (degree > 0). This can be usefull if the purpose is to make an interpretation friendly network. See e.g., http://jcom.sissa.it/archive/14/01/JCOM_1401_2015_A01}

\item{use_original_alpha}{if max_vertices is not NULL, this determines whether the lower alpha for selecting the top vertices is also used as a threshold for the edges, or whether the original value given in the alpha parameter is used.}

\item{k_is_n}{the disparity filter method for backbone extraction uses the number of existing edges (k) for each node, which can be arbitraty if there are many very weak ties, which is often the case in a co-occurence network. By setting k_is_n to TRUE, it is 'assumed' that all nodes are connected, which makes sense from a language model perspective (i.e. probability for co-occurence is never zero)}
}
\value{
A graph in the Igraph format
}
\description{
Based on the following paper: Serrano, M. A., Boguna, M., & Vespignani, A. (2009). Extracting the multiscale backbone of complex weighted networks. Proceedings of the National Academy of Sciences, 106(16), 6483-6488.
}
\examples{
\donttest{
tc = create_tcorpus(sotu_texts, doc_column = 'id')
tc$preprocess('token','feature', remove_stopwords = TRUE, use_stemming = TRUE, min_docfreq = 10)

g = semnet_window(tc, 'feature', window.size = 10)
igraph::vcount(g)
igraph::ecount(g)
gb = backbone_filter(g, max_vertices = 100)
igraph::vcount(gb)
igraph::ecount(gb)
plot_semnet(gb)
}
}
