% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_words.r
\name{plot.vocabularyComparison}
\alias{plot.vocabularyComparison}
\title{visualize vocabularyComparison}
\usage{
\method{plot}{vocabularyComparison}(x, n = 25, mode = c("both", "ratio_x",
  "ratio_y"), balance = T, size = c("chi2", "freq", "ratio"), ...)
}
\arguments{
\item{x}{a vocabularyComparison object, created with the \link{compare_corpus} or \link{compare_subset} method}

\item{n}{the number of words in the plot}

\item{mode}{use "both" to plot both overrepresented and underrepresented words using the plot_words function. Use "ratio_x" or "ratio_y" to only plot overrepresented or underrepresented words using dtm_wordcloud}

\item{balance}{if TRUE, get an equal amount of terms on the left (underrepresented) and right (overrepresented) side. If FALSE, the top chi words are used, regardless of ratio.}

\item{size}{use "freq", "chi2" or "ratio" for determining the size of words}

\item{...}{additional arguments passed to plot_words ("both" mode) or dtm_wordcloud (ratio modes)}
}
\description{
visualize vocabularyComparison
}
\examples{
## as example, compare SOTU paragraphs about taxes to rest
tc = create_tcorpus(sotu_texts[1:100,], doc_column = 'id')
comp = tc$compare_subset('token', query_x = 'tax*')

\dontrun{
plot(comp, balance=T)
plot(comp, mode = 'ratio_x')
plot(comp, mode = 'ratio_y')
}
}
