/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data;

import uno.informatics.data.DataType;

public class DataTypeConstants {
    public static final int UNKNOWN_ID = 0;
    public static final int BOOLEAN_ID = 1;
    public static final int SHORT_ID = 2;
    public static final int INT_ID = 4;
    public static final int LONG_ID = 8;
    public static final int FLOAT_ID = 16;
    public static final int DOUBLE_ID = 32;
    public static final int BIG_INTEGER_ID = 64;
    public static final int BIG_DECIMAL_ID = 128;
    public static final int DATE_ID = 256;
    public static final int STRING_ID = 512;
    public static final int DEFAULT_TYPE_IDS = 805;
    public static final int NUMBER_IDS = 254;
    public static final int INTEGER_IDS = 78;
    public static final int REAL_IDS = 176;
    public static final int BIG_NUMBER_IDS = 192;
    public static final int SIMPLE_ENTITY_ID = 1024;

    public static final int getConversionType(DataType dataType) {
        switch (dataType) {
            case BIG_DECIMAL: {
                return 128;
            }
            case BIG_INTEGER: {
                return 64;
            }
            case BOOLEAN: {
                return 1;
            }
            case DATE: {
                return 256;
            }
            case DOUBLE: {
                return 32;
            }
            case FLOAT: {
                return 16;
            }
            case INTEGER: {
                return 4;
            }
            case LONG: {
                return 8;
            }
            case SHORT: {
                return 2;
            }
        }
        return 512;
    }

    public static final DataType getDataType(int conversionType) {
        switch (conversionType) {
            case 128: {
                return DataType.BIG_DECIMAL;
            }
            case 64: {
                return DataType.BIG_INTEGER;
            }
            case 1: {
                return DataType.BOOLEAN;
            }
            case 256: {
                return DataType.DATE;
            }
            case 32: {
                return DataType.DOUBLE;
            }
            case 16: {
                return DataType.FLOAT;
            }
            case 4: {
                return DataType.INTEGER;
            }
            case 8: {
                return DataType.LONG;
            }
            case 2: {
                return DataType.SHORT;
            }
        }
        return DataType.STRING;
    }
}

