/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.common.io.text;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import uno.informatics.common.ConversionException;
import uno.informatics.common.ConversionUtilities;
import uno.informatics.common.io.RowReader;
import uno.informatics.common.io.text.AbstractTextFileHandler;

public class TextFileRowReader
extends AbstractTextFileHandler
implements RowReader {
    public static final int NO_OPTIONS = 0;
    public static final int PARSE_EMPTY_STRINGS = 1;
    public static final int CONVERT_VALUES = 2;
    public static final int IGNORE_MULTIPLE_DELIMITERS = 4;
    public static final int ROWS_SAME_SIZE = 8;
    public static final int REMOVE_WHITE_SPACE = 16;
    private int options = 0;
    private Map<Integer, Integer> conversionTypesMap;
    private int conversionTypesCount;
    private int[] conversionTypesArray = new int[0];
    private int defaultConversionTypes;
    private Pattern pattern;
    private BufferedReader bufferedReader;
    private String[] line;
    private String[] nextLine;
    private int defaultInt;
    private double defaultDouble;
    private boolean defaultBoolean;
    private static final String BUFFERREADER_NULL = "Buffer reader is undefined";

    private TextFileRowReader() {
    }

    public TextFileRowReader(String reference) throws IOException, FileNotFoundException {
        this();
        if (reference == null) {
            throw new FileNotFoundException("File undefined");
        }
        this.setFileReference(reference);
        this.initialise();
    }

    public TextFileRowReader(Path path) throws IOException, FileNotFoundException {
        this();
        if (path == null) {
            throw new FileNotFoundException("Path undefined");
        }
        this.setPath(path);
        this.initialise();
    }

    public TextFileRowReader(BufferedReader bufferedReader) throws IOException {
        this();
        if (bufferedReader == null) {
            throw new IOException("Buffered reader undefined");
        }
        this.bufferedReader = bufferedReader;
        this.initialise();
    }

    @Override
    public final boolean ready() {
        try {
            if (this.bufferedReader != null) {
                return this.bufferedReader.ready();
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public final void close() {
        try {
            if (this.bufferedReader != null) {
                this.bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bufferedReader = null;
    }

    public final int getOptions() {
        return this.options;
    }

    public final void setOptions(int options) throws IOException {
        if (options != this.options) {
            if (this.isInUse()) {
                throw new IOException("Options can not be changed while reader is in use");
            }
            this.options = options;
            this.updatePattern();
        }
    }

    @Override
    public final synchronized void setDelimiterString(String delimiter) throws IOException {
        super.setDelimiterString(delimiter);
        this.updatePattern();
    }

    @Override
    public final Object[][] readCellsAsArray() throws IOException {
        LinkedList<Object[]> rows = new LinkedList<Object[]>();
        while (this.nextRow()) {
            rows.add(this.getRowCellsAsArray());
        }
        Object[][] cells = new Object[rows.size()][];
        Iterator iterator = rows.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            cells[i] = (Object[])iterator.next();
            ++i;
        }
        return cells;
    }

    @Override
    public final List<List<Object>> readCells() throws IOException {
        LinkedList<List<Object>> cells = new LinkedList<List<Object>>();
        while (this.nextRow()) {
            cells.add(this.getRowCells());
        }
        return cells;
    }

    @Override
    public final boolean hasNextRow() {
        if (this.nextLine != null) {
            return true;
        }
        if (this.ready() && this.getRowPosition() < 0) {
            try {
                this.readNextLine();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public final boolean nextRow() throws IOException {
        if (this.hasNextRow()) {
            this.readNextLine();
            this.incrementRowIndex();
            this.updateRowSize(this.line != null ? this.line.length : 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNextColumn() {
        return this.getColumnIndex() + 1 < this.getRowSize();
    }

    @Override
    public boolean nextColumn() throws IOException {
        if (this.hasNextColumn()) {
            this.incrementColumnIndex();
            return true;
        }
        return false;
    }

    @Override
    public Object getCell() throws IOException {
        return this.parseCell(this.getColumnIndex());
    }

    @Override
    public String getCellAsString() throws IOException {
        return this.parseCellAsString(this.getColumnIndex());
    }

    @Override
    public double getCellAsDouble() throws IOException {
        return this.parseCellAsDouble(this.getColumnIndex());
    }

    @Override
    public int getCellAsInt() throws IOException {
        return this.parseCellAsInt(this.getColumnIndex());
    }

    @Override
    public boolean getCellAsBoolean() throws IOException {
        return this.parseCellAsBoolean(this.getColumnIndex());
    }

    @Override
    public final List<Object> getRowCells() throws IOException {
        if (this.getRowIndex() < 0) {
            throw new IOException("Reader before first row!");
        }
        return this.parseRowCells(this.getColumnIndex(), this.getRowSize());
    }

    @Override
    public final List<String> getRowCellsAsString() throws IOException {
        if (this.getRowIndex() < 0) {
            throw new IOException("Reader before first row!");
        }
        return this.parseRowCellsAsString(this.getColumnIndex(), this.getRowSize());
    }

    @Override
    public final List<Integer> getRowCellsAsInt() throws IOException {
        if (this.getRowIndex() < 0) {
            throw new IOException("Reader before first row!");
        }
        return this.parseRowCellsAsInteger(this.getColumnIndex(), this.getRowSize());
    }

    @Override
    public final List<Double> getRowCellsAsDouble() throws IOException {
        if (this.getRowIndex() < 0) {
            throw new IOException("Reader before first row!");
        }
        return this.parseRowCellsAsDouble(this.getColumnIndex(), this.getRowSize());
    }

    @Override
    public final List<Boolean> getRowCellsAsBoolean() throws IOException {
        if (this.getRowIndex() < 0) {
            throw new IOException("Reader before first row!");
        }
        return this.parseRowCellsAsBoolean(this.getColumnIndex(), this.getRowSize());
    }

    @Override
    public final Object[] getRowCellsAsArray() throws IOException {
        return this.parseRowCellsAsArray(this.getColumnIndex(), this.getRowSize());
    }

    @Override
    public final String[] getRowCellsAsStringArray() throws IOException {
        return this.parseRowCellsAsStringArray(this.getColumnIndex(), this.getRowSize());
    }

    @Override
    public final int[] getRowCellsAsIntArray() throws IOException {
        return this.parseRowCellsAsIntArray(this.getColumnIndex(), this.getRowSize());
    }

    @Override
    public final double[] getRowCellsAsDoubleArray() throws IOException {
        return this.parseRowCellsAsDoubleArray(this.getColumnIndex(), this.getRowSize());
    }

    @Override
    public final boolean[] getRowCellsAsBooleanArray() throws IOException {
        return this.parseRowCellsAsBooleanArray(this.getColumnIndex(), this.getRowSize());
    }

    protected Object parseValue(String text, int rowIndex, int columnIndex) throws IOException {
        try {
            return this.convertValue(text);
        }
        catch (ClassCastException e) {
            throw new IOException("Can not parse cell position " + rowIndex + "," + columnIndex + " due to " + e.getLocalizedMessage(), e);
        }
    }

    protected Object parseValue(String text, int rowIndex, int columnIndex, int conversionTypes) throws IOException {
        try {
            return this.convertValue(text, conversionTypes);
        }
        catch (Exception e) {
            throw new IOException("Can not parse cell position " + rowIndex + "," + columnIndex + " due to " + e.getLocalizedMessage(), e);
        }
    }

    protected Object convertValue(String text) {
        return ConversionUtilities.convertToObject(text);
    }

    protected Object convertValue(String text, int dataTypes) throws ConversionException {
        return ConversionUtilities.convertToObject(text, dataTypes);
    }

    @Override
    protected final void initialise() throws FileNotFoundException, IOException {
        super.initialise();
        this.defaultConversionTypes = 805;
        this.conversionTypesMap = new TreeMap<Integer, Integer>();
        this.conversionTypesCount = 0;
        this.conversionTypesArray = null;
        this.updatePattern();
        if (this.getPathReference() != null) {
            this.initialiseBufferedReader(TextFileRowReader.getBufferReader(this.getPathReference()));
        } else if (this.getPath() != null) {
            this.initialiseBufferedReader(TextFileRowReader.getBufferReader(this.getPath()));
        } else if (this.bufferedReader != null) {
            this.initialiseBufferedReader(this.bufferedReader);
        } else {
            throw new IOException("Unable to initialise reader");
        }
    }

    private void readNextLine() throws IOException {
        this.line = this.nextLine;
        this.nextLine = null;
        this.setColumnIndex(-1);
        while (this.bufferedReader.ready() && this.nextLine == null) {
            this.nextLine = this.readLine();
            this.incrementRowPosition();
        }
    }

    private String[] readLine() throws IOException {
        String line = this.bufferedReader.readLine();
        if (line != null && (line.trim().length() == 0 && this.isInStrictMode() || this.getCommentString() != null && line.trim().startsWith(this.getCommentString()))) {
            return null;
        }
        if (this.hasOption(4)) {
            return this.pattern.split(line);
        }
        return this.pattern.split(line, -1);
    }

    private final void initialiseBufferedReader(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            throw new NullPointerException(BUFFERREADER_NULL);
        }
        this.bufferedReader = bufferedReader;
    }

    private final void updatePattern() {
        this.pattern = Pattern.compile(this.getDelimiterString(), 32);
    }

    protected String convertToken(String string) {
        if (this.hasOption(16)) {
            return this.convertTokenWithTrim(string);
        }
        return this.convertTokenWithoutTrim(string);
    }

    protected String convertTokenWithTrim(String string) {
        String token = this.convertTokenWithoutTrim(string);
        if (token != null) {
            return token.trim();
        }
        return null;
    }

    protected String convertTokenWithoutTrim(String string) {
        if (this.hasOption(1)) {
            return string;
        }
        if (string != null) {
            if ("".equals(string.trim())) {
                return null;
            }
            return string;
        }
        return null;
    }

    protected int getDefaultConversionTypes() {
        return this.defaultConversionTypes;
    }

    public final void setDefaultConversionTypes(int defaultConversionTypes) {
        this.defaultConversionTypes = defaultConversionTypes;
    }

    public final int getConversionTypes(int index) {
        if (index >= 0 && this.conversionTypesMap.containsKey(index)) {
            return this.conversionTypesMap.get(index);
        }
        return this.defaultConversionTypes;
    }

    public final int[] getAllConversionTypes() {
        if (this.conversionTypesArray == null) {
            this.conversionTypesArray = new int[this.conversionTypesCount];
            Iterator<Map.Entry<Integer, Integer>> iterator = this.conversionTypesMap.entrySet().iterator();
            Map.Entry<Integer, Integer> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                this.conversionTypesArray[entry.getKey().intValue()] = entry.getValue();
            }
        }
        return this.conversionTypesArray;
    }

    @Override
    public final void setAllConversionTypes(int[] conversionTypes) {
        this.conversionTypesArray = null;
        this.conversionTypesCount = conversionTypes.length;
        for (int i = 0; i < conversionTypes.length; ++i) {
            this.conversionTypesMap.put(i, conversionTypes[i]);
        }
    }

    public final void setConversionTypes(int conversionTypes, int index) {
        if (index >= 0) {
            this.conversionTypesMap.put(index, conversionTypes);
            if (index >= this.conversionTypesCount) {
                this.conversionTypesCount = index + 1;
                this.conversionTypesArray = null;
            } else {
                this.conversionTypesArray[index] = conversionTypes;
            }
        }
    }

    private Object parseCell(int index) throws IOException {
        if (this.line != null && index < this.line.length) {
            if (this.conversionTypesCount > 0) {
                return this.parseValue(this.convertToken(this.line[index]), this.getRowIndex(), index, this.getConversionTypes(index));
            }
            return this.parseValue(this.convertToken(this.line[index]), this.getRowIndex(), index);
        }
        return null;
    }

    private String parseCellAsString(int index) throws IOException {
        if (this.line != null) {
            try {
                return this.convertToken(this.line[index]);
            }
            catch (Exception e) {
                throw new IOException("Can not parse cell position " + this.getRowIndex() + "," + index + " due to " + e.getLocalizedMessage(), e);
            }
        }
        throw new IOException("Can not convert to string");
    }

    private int parseCellAsInt(int index) throws IOException {
        if (this.line != null) {
            try {
                Integer value = ConversionUtilities.convertToInteger(this.convertTokenWithoutTrim(this.line[index]));
                if (value != null) {
                    return value;
                }
                return this.defaultInt;
            }
            catch (Exception e) {
                throw new IOException("Can not parse cell position " + this.getRowIndex() + "," + index + " due to " + e.getLocalizedMessage(), e);
            }
        }
        throw new IOException("Can not convert to int");
    }

    private Integer parseCellAsIntegerObject(int index) throws IOException {
        if (this.line != null) {
            try {
                return ConversionUtilities.convertToInteger(this.convertTokenWithoutTrim(this.line[index]));
            }
            catch (Exception e) {
                throw new IOException("Can not parse cell position " + this.getRowIndex() + "," + index + " due to " + e.getLocalizedMessage(), e);
            }
        }
        throw new IOException("Can not convert to int");
    }

    private double parseCellAsDouble(int index) throws IOException {
        if (this.line != null) {
            try {
                Double value = ConversionUtilities.convertToDouble(this.convertTokenWithoutTrim(this.line[index]));
                if (value != null) {
                    return value;
                }
                return this.defaultDouble;
            }
            catch (Exception e) {
                throw new IOException("Can not parse cell position " + this.getRowIndex() + "," + index + " due to " + e.getLocalizedMessage(), e);
            }
        }
        throw new IOException("Can not convert to int");
    }

    private Double parseCellAsDoubleObject(int index) throws IOException {
        if (this.line != null) {
            try {
                return ConversionUtilities.convertToDouble(this.convertTokenWithoutTrim(this.line[index]));
            }
            catch (Exception e) {
                throw new IOException("Can not parse cell position " + this.getRowIndex() + "," + index + " due to " + e.getLocalizedMessage(), e);
            }
        }
        throw new IOException("Can not convert to int");
    }

    private boolean parseCellAsBoolean(int index) throws IOException {
        if (this.line != null) {
            try {
                Boolean value = ConversionUtilities.convertToBoolean(this.convertTokenWithoutTrim(this.line[index]));
                if (value != null) {
                    return value;
                }
                return this.defaultBoolean;
            }
            catch (Exception e) {
                throw new IOException("Can not parse cell position " + this.getRowIndex() + "," + index + " due to " + e.getLocalizedMessage(), e);
            }
        }
        throw new IOException("Can not convert to int");
    }

    private Boolean parseCellAsBooleanObject(int index) throws IOException {
        if (this.line != null) {
            try {
                return ConversionUtilities.convertToBoolean(this.convertTokenWithoutTrim(this.line[index]));
            }
            catch (Exception e) {
                throw new IOException("Can not parse cell position " + this.getRowIndex() + "," + index + " due to " + e.getLocalizedMessage(), e);
            }
        }
        throw new IOException("Can not convert to int");
    }

    private List<Object> parseRowCells(int firstIndex, int requestedSize) throws IOException {
        ArrayList<Object> row;
        if (this.line != null) {
            int startIndex;
            int size;
            int n = size = requestedSize < this.line.length ? requestedSize : this.line.length;
            int n2 = firstIndex < 0 ? 0 : (startIndex = firstIndex >= size ? size : firstIndex);
            if (this.hasOption(8)) {
                int i;
                row = new ArrayList(requestedSize - startIndex);
                if (this.conversionTypesCount > 0) {
                    if (this.hasOption(16)) {
                        for (i = startIndex; i < size; ++i) {
                            row.add(this.parseValue(this.convertTokenWithTrim(this.line[i]), this.getRowIndex(), i, this.getConversionTypes(i)));
                        }
                    } else {
                        for (i = startIndex; i < size; ++i) {
                            row.add(this.parseValue(this.convertTokenWithoutTrim(this.line[i]), this.getRowIndex(), i));
                        }
                    }
                } else if (this.hasOption(16)) {
                    for (i = startIndex; i < size; ++i) {
                        row.add(this.parseValue(this.convertTokenWithTrim(this.line[i]), this.getRowIndex(), i, this.getConversionTypes(i)));
                    }
                } else {
                    for (i = startIndex; i < size; ++i) {
                        row.add(this.parseValue(this.convertTokenWithoutTrim(this.line[i]), this.getRowIndex(), i));
                    }
                }
                for (i = size; i < requestedSize; ++i) {
                    row.add(null);
                }
            } else {
                row = new ArrayList(size - startIndex);
                if (this.conversionTypesCount > 0) {
                    if (this.hasOption(16)) {
                        for (int i = startIndex; i < size; ++i) {
                            row.add(this.parseValue(this.convertTokenWithTrim(this.line[i]), this.getRowIndex(), i, this.getConversionTypes(i)));
                        }
                    } else {
                        for (int i = startIndex; i < size; ++i) {
                            row.add(this.parseValue(this.convertTokenWithoutTrim(this.line[i]), this.getRowIndex(), i));
                        }
                    }
                } else if (this.hasOption(16)) {
                    for (int i = startIndex; i < size; ++i) {
                        row.add(this.parseValue(this.convertTokenWithTrim(this.line[i]), this.getRowIndex(), i, this.getConversionTypes(i)));
                    }
                } else {
                    for (int i = startIndex; i < size; ++i) {
                        row.add(this.parseValue(this.convertTokenWithoutTrim(this.line[i]), this.getRowIndex(), i));
                    }
                }
            }
        } else {
            row = new ArrayList<Object>();
        }
        return row;
    }

    private List<String> parseRowCellsAsString(int firstIndex, int requestedSize) throws IOException {
        ArrayList<String> row;
        if (this.line != null) {
            int startIndex;
            int size;
            int n = size = requestedSize < this.line.length ? requestedSize : this.line.length;
            int n2 = firstIndex < 0 ? 0 : (startIndex = firstIndex >= size ? size : firstIndex);
            if (this.hasOption(8)) {
                int i;
                row = new ArrayList(requestedSize - startIndex);
                if (this.hasOption(16)) {
                    for (i = startIndex; i < size; ++i) {
                        row.add(this.convertTokenWithTrim(this.line[i]));
                    }
                } else {
                    for (i = startIndex; i < size; ++i) {
                        row.add(this.convertTokenWithoutTrim(this.line[i]));
                    }
                }
                for (i = size; i < requestedSize; ++i) {
                    row.add(null);
                }
            } else {
                row = new ArrayList(size - startIndex);
                if (this.hasOption(16)) {
                    for (int i = startIndex; i < size; ++i) {
                        row.add(this.convertTokenWithTrim(this.line[i]));
                    }
                } else {
                    for (int i = startIndex; i < size; ++i) {
                        row.add(this.convertTokenWithoutTrim(this.line[i]));
                    }
                }
            }
        } else {
            row = new ArrayList<String>();
        }
        return row;
    }

    private List<Integer> parseRowCellsAsInteger(int firstIndex, int requestedSize) throws IOException {
        ArrayList<Integer> row;
        if (this.line != null) {
            int startIndex;
            int size;
            int n = size = requestedSize < this.line.length ? requestedSize : this.line.length;
            int n2 = firstIndex < 0 ? 0 : (startIndex = firstIndex >= size ? size : firstIndex);
            if (this.hasOption(8)) {
                int i;
                row = new ArrayList(requestedSize - startIndex);
                for (i = startIndex; i < size; ++i) {
                    row.add(this.parseCellAsIntegerObject(i));
                }
                for (i = size; i < requestedSize; ++i) {
                    row.add(null);
                }
            } else {
                row = new ArrayList(size - startIndex);
                for (int i = startIndex; i < size; ++i) {
                    row.add(this.parseCellAsIntegerObject(i));
                }
            }
        } else {
            row = new ArrayList<Integer>();
        }
        return row;
    }

    private List<Double> parseRowCellsAsDouble(int firstIndex, int requestedSize) throws IOException {
        ArrayList<Double> row;
        if (this.line != null) {
            int startIndex;
            int size;
            int n = size = requestedSize < this.line.length ? requestedSize : this.line.length;
            int n2 = firstIndex < 0 ? 0 : (startIndex = firstIndex >= size ? size : firstIndex);
            if (this.hasOption(8)) {
                int i;
                row = new ArrayList(requestedSize - startIndex);
                for (i = startIndex; i < size; ++i) {
                    row.add(this.parseCellAsDoubleObject(i));
                }
                for (i = size; i < requestedSize; ++i) {
                    row.add(null);
                }
            } else {
                row = new ArrayList(size - startIndex);
                for (int i = startIndex; i < size; ++i) {
                    row.add(this.parseCellAsDoubleObject(i));
                }
            }
        } else {
            row = new ArrayList<Double>();
        }
        return row;
    }

    private List<Boolean> parseRowCellsAsBoolean(int firstIndex, int requestedSize) throws IOException {
        ArrayList<Boolean> row;
        if (this.line != null) {
            int startIndex;
            int size;
            int n = size = requestedSize < this.line.length ? requestedSize : this.line.length;
            int n2 = firstIndex < 0 ? 0 : (startIndex = firstIndex >= size ? size : firstIndex);
            if (this.hasOption(8)) {
                int i;
                row = new ArrayList(requestedSize - startIndex);
                for (i = startIndex; i < size; ++i) {
                    row.add(this.parseCellAsBooleanObject(i));
                }
                for (i = size; i < requestedSize; ++i) {
                    row.add(null);
                }
            } else {
                row = new ArrayList(size - startIndex);
                for (int i = startIndex; i < size; ++i) {
                    row.add(this.parseCellAsBooleanObject(i));
                }
            }
        } else {
            row = new ArrayList<Boolean>();
        }
        return row;
    }

    private Object[] parseRowCellsAsArray(int firstIndex, int requestedSize) throws IOException {
        Object[] row;
        if (this.line != null) {
            int size;
            int n = size = requestedSize < this.line.length ? requestedSize : this.line.length;
            int startIndex = firstIndex < 0 ? 0 : (firstIndex >= size ? size : firstIndex);
            row = this.hasOption(8) ? new Object[requestedSize - startIndex] : new Object[size - startIndex];
            if (this.conversionTypesCount > 0) {
                if (this.hasOption(16)) {
                    for (int i = startIndex; i < size; ++i) {
                        row[i - startIndex] = this.parseValue(this.convertTokenWithTrim(this.line[i]), this.getRowIndex(), i, this.getConversionTypes(i));
                    }
                } else {
                    for (int i = startIndex; i < size; ++i) {
                        row[i - startIndex] = this.parseValue(this.convertTokenWithoutTrim(this.line[i]), this.getRowIndex(), i);
                    }
                }
            } else if (this.hasOption(16)) {
                for (int i = startIndex; i < size; ++i) {
                    row[i - startIndex] = this.parseValue(this.convertTokenWithTrim(this.line[i]), this.getRowIndex(), i, this.getConversionTypes(i));
                }
            } else {
                for (int i = startIndex; i < size; ++i) {
                    row[i - startIndex] = this.parseValue(this.convertTokenWithoutTrim(this.line[i]), this.getRowIndex(), i);
                }
            }
        } else {
            row = new Object[]{};
        }
        return row;
    }

    private String[] parseRowCellsAsStringArray(int firstIndex, int requestedSize) throws IOException {
        String[] row;
        if (this.line != null) {
            int size;
            int n = size = requestedSize < this.line.length ? requestedSize : this.line.length;
            int startIndex = firstIndex < 0 ? 0 : (firstIndex >= size ? size : firstIndex);
            row = this.hasOption(8) ? new String[requestedSize - startIndex] : new String[size - startIndex];
            if (this.hasOption(16)) {
                for (int i = startIndex; i < size; ++i) {
                    row[i - startIndex] = this.convertTokenWithTrim(this.line[i]);
                }
            } else {
                for (int i = startIndex; i < size; ++i) {
                    row[i - startIndex] = this.convertTokenWithoutTrim(this.line[i]);
                }
            }
        } else {
            row = new String[]{};
        }
        return row;
    }

    private int[] parseRowCellsAsIntArray(int firstIndex, int requestedSize) throws IOException {
        int[] row;
        if (this.line != null) {
            int size;
            int n = size = requestedSize < this.line.length ? requestedSize : this.line.length;
            int startIndex = firstIndex < 0 ? 0 : (firstIndex >= size ? size : firstIndex);
            row = this.hasOption(8) ? new int[requestedSize - startIndex] : new int[size - startIndex];
            for (int i = startIndex; i < size; ++i) {
                row[i - startIndex] = this.parseCellAsInt(i);
            }
        } else {
            row = new int[]{};
        }
        return row;
    }

    private double[] parseRowCellsAsDoubleArray(int firstIndex, int requestedSize) throws IOException {
        double[] row;
        if (this.line != null) {
            int size;
            int n = size = requestedSize < this.line.length ? requestedSize : this.line.length;
            int startIndex = firstIndex < 0 ? 0 : (firstIndex >= size ? size : firstIndex);
            row = this.hasOption(8) ? new double[requestedSize - startIndex] : new double[size - startIndex];
            for (int i = startIndex; i < size; ++i) {
                row[i - startIndex] = this.parseCellAsDouble(i);
            }
        } else {
            row = new double[]{};
        }
        return row;
    }

    private boolean[] parseRowCellsAsBooleanArray(int firstIndex, int requestedSize) throws IOException {
        boolean[] row;
        if (this.line != null) {
            int size;
            int n = size = requestedSize < this.line.length ? requestedSize : this.line.length;
            int startIndex = firstIndex < 0 ? 0 : (firstIndex >= size ? size : firstIndex);
            row = this.hasOption(8) ? new boolean[requestedSize - startIndex] : new boolean[size - startIndex];
            for (int i = startIndex; i < size; ++i) {
                row[i - startIndex] = this.parseCellAsBoolean(i);
            }
        } else {
            row = new boolean[]{};
        }
        return row;
    }

    private boolean hasOption(int option) {
        return (this.options & option) > 0;
    }

    private static final BufferedReader getBufferReader(Path path) throws FileNotFoundException, IOException {
        if (path != null) {
            return Files.newBufferedReader(path);
        }
        throw new FileNotFoundException("File object is null");
    }

    private static final BufferedReader getBufferReader(String fileReference) throws FileNotFoundException, IOException {
        BufferedReader bufferedReader = null;
        try {
            URL refURL = new URL(fileReference);
            bufferedReader = new BufferedReader(new InputStreamReader(refURL.openStream()));
        }
        catch (MalformedURLException malformedURLException) {
            bufferedReader = new BufferedReader(new FileReader(fileReference));
        }
        return bufferedReader;
    }
}

