% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivarsusie.R
\name{cophe.susie}
\alias{cophe.susie}
\title{run \code{cophe.susie} using susie to detect separate signals}
\usage{
cophe.susie(
  dataset,
  querysnpid,
  querytrait,
  pa = 3.82e-05,
  pc = 0.00182,
  p1 = NULL,
  p2 = NULL,
  p12 = NULL,
  susie.args = list()
)
}
\arguments{
\item{dataset}{\emph{either} a list with specifically named elements defining the dataset
to be analysed. (see
\link{check_dataset}), or the result of running \link{runsusie} on such a
dataset}

\item{querysnpid}{Id of the query variant}

\item{querytrait}{Query trait name}

\item{pa}{prior probability that a non-query variant is causally associated with the query trait (cophescan prior), default 3.82e-5}

\item{pc}{prior probability that the query variant is causally associated with the query trait (cophescan prior), default 1.82e-3 (cophescan prior)}

\item{p1}{prior probability a SNP is associated with trait 1, (coloc prior), pc derived by using \eqn{pc =  p12/p1+p12}; use p1, p2, p12 only when pa and pc are unavailable (See vignettes)}

\item{p2}{prior probability a SNP is associated with trait 2,  (coloc prior), pa derived by using \eqn{pa = p2}}

\item{p12}{prior probability a SNP is associated with both traits,  (coloc prior), pc derived by using \eqn{pc =  p12/p1+p12}}

\item{susie.args}{a named list of additional arguments to be passed to
\link{runsusie}}
}
\value{
a list, containing elements
\itemize{
\item summary a data.table of posterior
probabilities of each global hypothesis, one row per pairwise comparison
of signals from the two traits
\item results a data.table of detailed results giving the posterior probability
for each snp to be jointly causal for both traits \emph{assuming Hc is true}.
Please ignore this column if the corresponding posterior support for H4
is not high.
\item priors a vector of the priors used for the analysis
}
}
\description{
Check if a variant causally associated in one trait might be causal in another trait
}
\examples{
library(cophescan)
data(cophe_multi_trait_data)
query_trait_1 <- cophe_multi_trait_data$summ_stat[['Trait_1']]
querysnpid <- cophe_multi_trait_data$querysnpid
query_trait_1$LD <- cophe_multi_trait_data$LD
res.susie <- cophe.susie(query_trait_1, querysnpid = querysnpid, querytrait='Trait_1')
summary(res.susie)
}
\author{
Ichcha Manipur
}
