% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svywattsdec.R
\name{svywattsdec}
\alias{svywattsdec}
\alias{svywattsdec.survey.design}
\alias{svywattsdec.svyrep.design}
\alias{svywattsdec.DBIsvydesign}
\title{Watts poverty index decomposition (EXPERIMENTAL)}
\usage{
svywattsdec(formula, design, ...)

\method{svywattsdec}{survey.design}(
  formula,
  design,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 0.6,
  quantiles = 0.5,
  na.rm = FALSE,
  thresh = FALSE,
  ...
)

\method{svywattsdec}{svyrep.design}(
  formula,
  design,
  type_thresh = "abs",
  abs_thresh = NULL,
  percent = 0.6,
  quantiles = 0.5,
  na.rm = FALSE,
  thresh = FALSE,
  ...
)

\method{svywattsdec}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{additional arguments. Currently not used.}

\item{type_thresh}{type of poverty threshold. If "abs" the threshold is fixed and given the value
of abs_thresh; if "relq" it is given by percent times the quantile; if "relm" it is percent times the mean.}

\item{abs_thresh}{poverty threshold value if type_thresh is "abs"}

\item{percent}{the multiple of the the quantile or mean used in the poverty threshold definition}

\item{quantiles}{the quantile used used in the poverty threshold definition}

\item{na.rm}{Should cases with missing values be dropped?}

\item{thresh}{return the poverty threshold value}
}
\value{
Object of class "\code{cvydstat}", with estimates for the Watts index, FGT(0), Watts Poverty Gap Ratio, and Theil(poor incomes) with a "\code{var}" attribute giving the variance-covariance matrix.
A "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the Watts (1968) poverty measure and its components
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\note{
This function is experimental and is subject to change in later versions.
}
\examples{
library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design

des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep( des_eusilc )

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep( des_eusilc_rep )

# absolute poverty threshold
svywattsdec(~eqincome, des_eusilc, abs_thresh=10000)
# poverty threshold equal to arpt
svywattsdec(~eqincome, des_eusilc, type_thresh= "relq" , thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svywattsdec(~eqincome, des_eusilc, type_thresh= "relm" , thresh = TRUE)

#  using svrep.design:
# absolute poverty threshold
svywattsdec(~eqincome, des_eusilc_rep, abs_thresh=10000)
# poverty threshold equal to arpt
svywattsdec(~eqincome, des_eusilc_rep, type_thresh= "relq" , thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svywattsdec(~eqincome, des_eusilc_rep, type_thresh= "relm" , thresh = TRUE)

\dontrun{

# database-backed design
library(RSQLite)
library(DBI)
dbfile <- tempfile()
conn <- dbConnect( RSQLite::SQLite() , dbfile )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfile,
		dbtype="SQLite"
	)


dbd_eusilc <- convey_prep( dbd_eusilc )

# absolute poverty threshold
svywattsdec(~eqincome, dbd_eusilc, abs_thresh=10000)
# poverty threshold equal to arpt
svywattsdec(~eqincome, dbd_eusilc, type_thresh= "relq" , thresh = TRUE)
# poverty threshold equal to 0.6 times the mean
svywattsdec(~eqincome, dbd_eusilc, type_thresh= "relm" , thresh = TRUE)

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
McKinley L. Blackburn (1989). Poverty measurement: an index related to a Theil measure of inequality.
\emph{Journal of Business & Economic Statistics}, Vol.7, No.4, pp. 475-481,
URL \url{https://amstat.tandfonline.com/doi/abs/10.1080/07350015.1989.10509760}.

Satya R. Chakravarty, Joseph Deutsch and Jacques Silber (2008).
On the Watts multidimensional poverty index and its decomposition.
\emph{World Development}, Vol.36, No.6, pp.1067-1077.

Harold W. Watts (1968). An economic definition of poverty.
\emph{Institute For Research on Poverty Discussion Papers}, n.5.
University of Wisconsin. URL \url{https://www.irp.wisc.edu/publications/dps/pdfs/dp568.pdf}.

Guillaume Osier (2009). Variance estimation for complex indicators
of poverty and inequality. \emph{Journal of the European Survey Research
Association}, Vol.3, No.3, pp. 167-195,
ISSN 1864-3361, URL \url{https://ojs.ub.uni-konstanz.de/srm/article/view/369}.

Jean-Claude Deville (1999). Variance estimation for complex statistics and estimators:
linearization and residual techniques. Survey Methodology, 25, 193-203,
URL \url{https://www150.statcan.gc.ca/n1/en/catalogue/12-001-X19990024882}.
}
\seealso{
\code{\link{svywatts},\link{svyfgt},\link{svyfgt}}
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
