% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald_CI_OR_Laplace_paired_2x2.R
\name{Wald_CI_OR_Laplace_paired_2x2}
\alias{Wald_CI_OR_Laplace_paired_2x2}
\title{The Wald confidence interval for the conditional odds ratio with Laplace adjustment}
\usage{
Wald_CI_OR_Laplace_paired_2x2(n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing lower, upper and point estimates of the statistic
}
\description{
The Wald confidence interval for the conditional odds ratio with Laplace adjustment

Described in Chapter 8 "The Paired 2x2 Table"
}
\examples{

# Floppy eyelid syndrome vs obstructive sleep apnea (Ezra et al., 2010)
n <- rbind(c(7, 25), c(2, 68))
Wald_CI_OR_Laplace_paired_2x2(n)

}
