% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-ContainerS3.R, R/GroupGenericMath.R,
%   R/GroupGenericSummary.R, R/Ops-arithmetic.R, R/Ops-compare.R,
%   R/Ops-extract.R, R/Ops-replace.R, R/add.R, R/at.R, R/at2.R, R/clear.R,
%   R/clone.R, R/count.R, R/delete.R, R/delete_at.R, R/discard.R,
%   R/discard_at.R, R/has.R, R/has_name.R, R/is_empty.R, R/peek_at.R,
%   R/peek_at2.R, R/pop.R, R/rename.R, R/replace.R, R/replace_at.R
\name{ContainerS3}
\alias{ContainerS3}
\alias{container}
\alias{cont}
\alias{as.container}
\alias{as.cont}
\alias{is.container}
\alias{as.list.Container}
\alias{length.Container}
\alias{names.Container}
\alias{names<-.Container}
\title{Container - Enhancing R's list}
\usage{
container(...)

cont(...)

as.container(x)

as.cont(x)

is.container(x)

\method{as.list}{Container}(x, ...)

\method{length}{Container}(x)

\method{names}{Container}(x)

\method{names}{Container}(x) <- value
}
\arguments{
\item{...}{(possibly named) elements to be put into or removed from the
\link{Container}, or additional arguments passed from and to methods.}

\item{x}{\code{R} object of \code{ANY} type for \link{as.container} and \link{is.container}
or of class \link{Container} for the \code{S3} methods.}

\item{value}{\code{character} vector of names.}
}
\description{
A container is a data structure with typical member
functions to insert, delete and access elements from the container
object. It can be considered as a base R \link{list} with
extended functionality. The \link{Container} class also serves as the base
class for \link{Deque}, \link{Set}, and \link{Dict} objects.
}
\details{
Methods that alter \link{Container} objects usually come in two versions
providing either copy or reference semantics where the latter start with
\code{'ref_'} to note the reference semantic, for example, \code{\link[=add]{add()}} and \code{\link[=ref_add]{ref_add()}}.

\itemize{
\item \code{container(...)} initializes and returns a \link{Container} object.
}

\itemize{
\item \code{cont(...)} is a short cut for \code{container(...)}.
}

\itemize{
\item \code{as.container(x)} or \code{as.cont(x)} coerce \code{x} to a \link{Container}
}

\itemize{
\item \code{is.container(x)} check if \code{x} is a \link{Container}
}

\itemize{
\item \code{as.list(x)} converts container \code{x} to a base R \link{list}. All of
the container's elements are copied (deeply) during the conversion.
}

\itemize{
\item \code{length(x)} return the number of elements contained in \code{x}.
}

\itemize{
\item \code{names(x)} return the names of the elements contained in \code{x}.
}

\itemize{
\item \code{names(x) <- value} sets the names of \code{x}.
}

\itemize{
\item \code{x + y} combines \code{x} and \code{y} into a new container by appending \code{y}
to \code{x}.
}

\itemize{
\item \code{x - y} element-wise discards all items of \code{y} from \code{x}, given
the element was contained in \code{x}. The result is always a container.
}

\itemize{
\item \code{x == y} is \code{TRUE} if the contents of \code{x} and \code{y} are
lexicographically \emph{equal}.
}

\itemize{
\item \code{x != y} is \code{TRUE} if the contents of \code{x} and \code{y} are
not equal.
}

\itemize{
\item \code{x < y} is \code{TRUE} if the contents of x are lexicographically
\emph{less} than the contents of y.
}

\itemize{
\item \code{x <= y} is \code{TRUE} if the contents of x are lexicographically
\emph{less} than or \emph{equal} to the contents of y.
}

\itemize{
\item \code{add(.x, ...)} and \code{ref_add(.x, ...)} add elements to \code{.x}.
}

\itemize{
\item \code{at(.x, ...,)} returns the value at the given indices. Indices
can be letters or numbers or both. All indices must exist.
}

\itemize{
\item \code{at2(x, index)} returns the value at the given index or signals an error
if not found.
}

\itemize{
\item \code{clear(x)} and \code{ref_clear(x)} remove all elements from \code{x}.
}

\itemize{
\item \code{clone(x)} create a copy of \code{x}.
}

\itemize{
\item \code{count(x, elem)} count how often \code{elem} occurs in \code{x}.
}

\itemize{
\item \code{delete(.x, ...)} and \code{ref_delete(.x, ...)} find and remove elements.
If one or more elements don't exist, an error is signaled.
}

\itemize{
\item \code{delete_at(.x, ...)} and \code{ref_delete_at(.x, ...)} find and remove values at
given indices. If any given index is invalid, an error is signaled.
}

\itemize{
\item \code{discard(.x, ...)} and \code{ref_discard(.x, ...)} find and discard elements.
Elements that don't exist, are ignored.
}

\itemize{
\item \code{discard_at(.x, ...)} and \code{ref_discard_at(.x, ...)} find and discard values
at given indices. Invalid indices are ignored.
}

\itemize{
\item \code{has(x, elem)} \code{TRUE} if element is in \code{x} and otherwise \code{FALSE}.
}

\itemize{
\item \code{has_name(x, name)} check if \code{name} is in \code{x}
}

\itemize{
\item \code{is_empty(x)} \code{TRUE} if object is empty otherwise \code{FALSE}
}

\itemize{
\item \code{peek_at(x, ..., .default = NULL)} returns the value at the given indices
or (if not found) the given default value.
}

\itemize{
\item \code{peek_at2(x, index, default)} returns the value at the given index or (if
not found) the given default value.
}

\itemize{
\item \code{ref_pop(.x, index)} return element at given index and remove it
from the \code{container} object.
}

\itemize{
\item \code{rename(.x, old, new)} and \code{ref_rename(.x, old, new)} rename one or more keys
from \code{old} to \code{new}, respectively, by copy and in place (i.e. by reference).
}

\itemize{
\item \code{replace(.x, old, new, add = FALSE)} and
\code{ref_replace(.x, old, new, add = FALSE)} try to find element \code{old} and
replace it with element \code{new}. If \code{old} does not exist, an error is raised,
unless \code{add} was set to \code{TRUE}.
}

\itemize{
\item \code{replace_at(.x, .., .add = FALSE)} and \code{ref_replace_at(.x, ..., .add = FALSE)}
replace values at given indices. If a given index is invalid, an error is
signaled unless \code{.add} was set to \code{TRUE}.
}
}
\examples{
co = container(1:5, c = container("a", 1), l = list())
is.container(co)
print(co)
length(co)
names(co)

unpack(co)   # flatten recursively similar to unlist

# Math
co = container(1, 2, -(3:5))
co
abs(co)
cumsum(co)
round(co)
exp(co)

# Summary
range(co)
min(co)
max(co)

# Arithmetic
c1 = container(1, 1:2)
c2 = container(2, 1:2)
c1 + c2     # same as c(c1, c2)
c2 + c1     # same as c(c2, c1)

c1 - c2
c2 - c1
c1 - c1

# Comparison
c1 = container(1, 2, 3)
c2 = container(1, 3, 2)
c1 == c1            # TRUE
c1 != c2            # TRUE
c1 <= c1            # TRUE
c1 == c2            # FALSE
c1 < c2             # TRUE
c1 < container(2)   # TRUE
c1 < container()    # FALSE

# Extract or replace
co = container(a = 1, b = 2, c = 3, d = 4)
co[1:2]
co[1, 4]
co["d", 2]
co[list("d", 2)]
co[0:10]

co = container(a = 1, b = 2)
co[[1]]
co[["a"]]
co[["x"]]
co = container(a = 1, b = "bar")
(co[1:2] <- 1:2)

\dontrun{
co[3] <- 3 # index out of range
}
(co[list(1, "b")] <- 3:4)   # mixed numeric/character index

co = container(a = 1, b = 2)
co[[1]] <- 9
co[["b"]] <- 8
co[["x"]] <- 7
co$z <- 99
print(co)

# Replace 8 by 0
co[[{8}]] <- 0
print(co)


co = container(a = 1, b = "bar")
co$f <- 3
co$b <- 2
co


co = container(1)
add(co, 1, b = 2, c = container(1:3))


co = container(a = 1, 2, b = 3, 4)
at(co, 1:3)
at(co, "a", "b", 2)
\dontrun{
at(co, "x")     # index 'x' not found
at(co, 1:10)    # index 5 exceeds length of Container
}

co = container(a = 1, 2, b = 3, 4)
at2(co, 1)
at2(co, "a")
at2(co, 2)
\dontrun{
at2(co, "x")     # index 'x' not found
at2(co, 5)       # index 5 exceeds length of Container
}

co = container(1, 2, mean)
clear(co)
print(co)    # Original was not touched
ref_clear(co)   # Clears original
print(co)

co = container(1, 2, 3)
co2 = clone(co)
co == co2

co = container("a", "b", "a", mean, mean)
count(co, "a")
count(co, mean)
count(co, "c")

co = container("a", 1:3, iris)
print(co)
delete(co, 1:3, "a")
delete(co, iris)
\dontrun{
delete(co, "b")   # "b" is not in Container
}

co = container(a = 1, b = 2, 3)
delete_at(co, "a", "b")          # [3]
delete_at(co, 1:2)               # [3]
delete_at(co, "a", 3)            # [b = 2]
\dontrun{
delete_at(co, 4)                 # index out of range
delete_at(co, "x")               # names(s) not found: 'x'
}

co = container("a", num = 1:3, data = iris)
print(co)
discard(co, 1:3, "a")
discard(co, iris)
discard(co, "b")  # ignored

co = container(a = 1, b = 2, 3)
discard_at(co, "a", "b")         # [3]
discard_at(co, 1:2)              # [3]
discard_at(co, "a", 3)           # [b = 2]
discard_at(co, "x")              # ignored

co = container(1, 2, mean)
has(co, 1)                   # TRUE
has(co, mean)                # TRUE
has(co, 1:2)                 # FALSE

co = container(a = 1, 2, f = mean)
has_name(co, "a")    # TRUE
has_name(co, "f")    # TRUE
has_name(co, "2")    # FALSE

co = container(1, 2)
is_empty(co)
is_empty(clear(co))

co = container(a = 1, 2, b = 3, 4)
peek_at(co, 1)
peek_at(co, "a")
peek_at(co, "x")
peek_at(co, "x", .default = 0)
peek_at(co, "a", "x", 2, 9, .default = -1)

co = container(a = 1, 2, b = 3, 4)
peek_at2(co, 1)
peek_at2(co, "a")
peek_at2(co, "x")
peek_at2(co, "x", default = 0)

co = container(a = 1, b = 1:3, d = "foo")
ref_pop(co, "b")
ref_pop(co, 1)

\dontrun{
ref_pop(co, "x")  # index 'x' not found
}
co = container(a = 1, b = 2, 3)
rename(co, c("a", "b"), c("a1", "y"))
print(co)
ref_rename(co, c("a", "b"), c("a1", "y"))
print(co)

co = container("x", 9)
replace(co, 9, 0)
replace(co, "x", 0)
\dontrun{
replace(co, "z", 0)              # old element ("z") is not in Container
}
replace(co, "z", 0, add = TRUE)  # ok, adds the element

co = container(a = 0, b = "z")
replace_at(co, a = 1, b = 2)
replace_at(co, 1:2, 1:2)                 # same
replace_at(co, c("a", "b"), list(1, 2))  # same

\dontrun{
replace_at(co, x = 1)                    # names(s) not found: 'x'
}
replace_at(co, x = 1, .add = TRUE)       # ok (adds x = 1)
}
\seealso{
For the class documentation see \link{Container}.
Objects of the derived classes can be created by \link{deque}, \link{setnew}, and
\link{dict}.
}
