% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-list.R
\name{opts_list}
\alias{opts_list}
\title{Constructive options for type 'list'}
\usage{
opts_list(
  constructor = c("list", "list2"),
  ...,
  trim = NULL,
  fill = c("vector", "new_list", "+", "...", "none")
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the object, see Details section.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}

\item{trim}{\code{NULL} or integerish. Maximum of elements showed before it's trimmed.
Note that it will necessarily produce code that doesn't reproduce the input.
This code will parse without failure but its evaluation might fail.}

\item{fill}{String. Method to use to represent the trimmed elements.}
}
\value{
An object of class <constructive_options/constructive_options_list>
}
\description{
These options will be used on objects of type 'list'.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"list"} (default): Build the object by calling \code{list()}.
\item \code{"list2"}: Build the object by calling \code{rlang::list2()}, the only difference with
the above is that we keep a trailing comma when the list is not trimmed and the call
spans several lines.
}

If \code{trim} is provided, depending on \code{fill} we will present trimmed elements as followed:
\itemize{
\item \code{"vector"} (default): Use \code{vector()}, so for instance \code{list("a", "b", "c")} might become \code{c(list("a"), vector("list", 2))}.
\item \code{"new_list"}: Use \code{rlang::new_list()}, so for instance \code{list("a", "b", "c")} might become \code{c(list("a"), rlang::new_list(2))}.
\item \code{"+"}: Use unary \code{+}, so for instance \code{list("a", "b", "c")} might become \code{list("a", +2)}.
\item \code{"..."}: Use \code{...}, so for instance \code{list("a", "b", "c")} might become \code{list("a", ...)}
\item \code{"none"}: Don't represent trimmed elements.
}

When \code{trim} is used the output is parsable but might not be possible to evaluate,
especially with \code{fill = "..."}. In that case you might want to set \code{check = FALSE}
}
