% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{permissions}
\alias{permissions}
\alias{content_add_user}
\alias{content_add_group}
\alias{content_delete_user}
\alias{content_delete_group}
\alias{get_user_permission}
\alias{get_my_permission}
\alias{get_group_permission}
\alias{get_content_permissions}
\title{Content permissions}
\usage{
content_add_user(content, guid, role = c("viewer", "owner"))

content_add_group(content, guid, role = c("viewer", "owner"))

content_delete_user(content, guid)

content_delete_group(content, guid)

get_user_permission(content, guid, add_owner = TRUE)

get_my_permission(content, add_owner = TRUE)

get_group_permission(content, guid)

get_content_permissions(content, add_owner = TRUE)
}
\arguments{
\item{content}{An R6 content object}

\item{guid}{The guid associated with either a user (for \code{content_add_user}) or group (for \code{content_add_group})}

\item{role}{The role to assign to a user. Either "viewer" or "owner." Defaults to "viewer"}

\item{add_owner}{Optional. Whether to include the owner in returned
permission sets. Default is TRUE. The owner will have an NA_character_
permission "id"}
}
\description{
Get or set content permissions for a content item
}
\details{
Permission modification:
\itemize{
\item \verb{content_add_*} adds a permission to the content
\item \verb{content_delete_*} removes a permission from the content
}

Permission retrieval:
\itemize{
\item \code{get_content_permissions()} lists permissions
\item \code{get_my_permission()} gets the permission associated with the caller.
\item \code{get_user_permission()} gets the permissions associated with a given user.
It does not evaluate group memberships
\item \code{get_group_permission()} gets the permissions associated with a given
group.
}

NOTE: by default, the owner is injected with an "NA_character_" permission id.
This makes it easier to find / isolate this record.
}
\seealso{
Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{dashboard_url_chr}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_jobs}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{set_image_path}()},
\code{\link{set_run_as}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
