% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_commission_list.R
\name{sen_commission_positions}
\alias{sen_commission_positions}
\title{Information on positions (jobs) that legislators may occupy
in commissions in the Federal Senate}
\usage{
sen_commission_positions(active = c("Both", "Yes", "No"), ascii = TRUE)
}
\arguments{
\item{active}{\code{character}. If "No", returns all positions, otherwise
returns positions that are presently active.}

\item{ascii}{\code{logical}. If TRUE, certain strings are converted to ascii
format.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Information on positions (jobs) that legislators may occupy
in commissions in the Federal Senate.
}
\details{
Returns a data frame with the following variables:
\itemize{
 \item{\code{comm_position_id: }}{unique code for each position.}
 \item{\code{comm_position: }}{name of the position.}
 \item{\code{comm_position_active: }}{whether the position is currently active or not.}
}
}
\examples{
jobs <- sen_commission_positions(active = "No")
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
