% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{condvis}
\alias{condvis}
\title{Creates Condvis Shiny app}
\usage{
condvis(
  data,
  model = NULL,
  response = NULL,
  sectionvars = NULL,
  conditionvars = NULL,
  predsInit = NULL,
  pointColor = c("steelblue", "grey0"),
  cPlotPCP = FALSE,
  cPlotn = 1000,
  orderConditionVars = "default",
  threshold = 1,
  thresholdmax = NULL,
  linecols = NULL,
  showsim = NULL,
  theta3d = 45,
  phi3d = 20,
  dataplot = "pcp",
  tours = NULL,
  predictArgs = NULL,
  xlim = NULL,
  ylim = NULL,
  zlim = NULL,
  density = FALSE,
  showdata = density == FALSE,
  displayHeight = 950
)
}
\arguments{
\item{data}{the dataset used for the fit. Should not have NAs for response, sectionvars or conditionvars.}

\item{model}{A fitted model or list of models. May be NULL.}

\item{response}{name of response variable. If null, tries to extract from model.}

\item{sectionvars}{names of sectionvars. If null, extracts from data.}

\item{conditionvars}{names of condition vars. If null, extracts from data.}

\item{predsInit}{Optionally provide starting value for some predictors. Defaults to medoid.}

\item{pointColor}{a color, or the name of variable to be used for coloring. If the named variable is numeric, it is first converted to a factor with 3 levels.}

\item{cPlotPCP}{if TRUE, conditionplots are drawn as a single PCP (for more than two conditionvars)}

\item{cPlotn}{Defaults to 1000. Shows a sample of this number of points in conditionplots. Non-numeric values are ignored.}

\item{orderConditionVars}{If supplied, a function to order the Condition Vars}

\item{threshold}{used for similarity weights, defaults to 1.}

\item{thresholdmax}{maximum value allowed of threshold.}

\item{linecols}{vector of colors to be used for fits}

\item{showsim}{if TRUE, shows sim in conditionplots with points/lines. Defaults to TRUE with 150 or fewer cases.}

\item{theta3d, phi3d}{Angles defining the viewing direction for 3d surface. \code{theta3d}
gives the azimuthal direction and \code{phi3d} the colatitude. See
\code{\link[graphics]{persp}}.}

\item{dataplot}{"pcp" or "pairs". Used when there is no response, or more than two sectionvars.}

\item{tours}{A list of pre-calculated tours}

\item{predictArgs}{a list with one entry per fit, giving arguments for CVpredict}

\item{xlim}{passed on to sectionplot}

\item{ylim}{passed on to sectionplot}

\item{zlim}{passed on to sectionplot}

\item{density}{default FALSE. Use TRUE if model is a density function.}

\item{showdata}{defaults to \code{density==TRUE}. If FALSE, data on section not shown.}

\item{displayHeight}{supply a value for the display height}
}
\description{
Creates Condvis Shiny app
}
\examples{
fit <- lm(mpg ~ wt+hp+am, data=mtcars)
if(interactive()){
condvis(mtcars,fit, response="mpg",sectionvars="wt", conditionvars=c("am", "hp"), pointColor ="red")
}
}
