% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeedProduction.R
\name{SeedProduction}
\alias{SeedProduction}
\title{Calculating number of produced seeds}
\usage{
SeedProduction(compet, b0 = 1, K = 200, ...)
}
\arguments{
\item{compet}{Matrix of pairwise competition coefficients}

\item{b0}{Probability of producing seed, if no competition}

\item{K}{Critical level of competition (See Details)}

\item{...}{any additional parameters}
}
\value{
Matrix of produced seeds
}
\description{
Number of seeds calculated following the formula used by Botta-Dukat & Czucz (2016).
This built-in function can be replaced by a user-defined one.
}
\details{
Each individual produces one seed or does not produce seed at all.
Probability of seed production is a decreasing sigmoid function of strength of
competition  (sum of abundances weighted by competition coefficients).
If strength of competition is higher than parameter K, probability is set to
zero. See \code{vignette("competition")} for formulas
}
