% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgrep.R
\name{cgrep}
\alias{cgrep}
\title{a function to select columns by 'regex'}
\usage{
cgrep(x, pattern, dim = c("c", "r"))
}
\arguments{
\item{x}{A dataframe, list a matrix with column names or a named numeric.}

\item{pattern}{A search string}

\item{dim}{A character either "c" for selection of columns or "r" for selection of rows, if x is a list this
parameter has no meaning}
}
\value{
A Dataframe, list or matrix where the column- or row names match the pattern. By default the
selecion is by column, unless the dim parameter specifies "r" for rows. If f x is not a dataframe and if
 a single column or row is selected 'R' will flatten the results to a vector.
}
\description{
Select columns (or rows) by 'perl' regular expression. See \link[base]{regex}\{base\} for
'regex' documenation. 'regex' is a very powerful grammar to match strings.
}
\examples{
 head(cgrep(iris, "^.+$")) # matches all columns that have non-empty column names and thus
 #drops all columns with empty names

 head(cgrep(iris, "^Petal\\\\.")) # matches all columns that have  names starting with the
 #string "Petal."
 head(cgrep(iris, "\\\\.")) # columns with names that contain a dot
 head(cgrep(iris, "\\\\.[Ww]idth$")) # columns with names ending in the string ".width" or ".Width".
 head(cgrep(iris, "^[SP]e.al")) # columns that have names starting with either capital
 #'S' or 'P' then an 'e' followed by any character and then 'al'

}
\seealso{
\link[base]{regex}\{base\}
}

