% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_sequential.R
\name{scale_colour_discrete_sequential}
\alias{scale_colour_discrete_sequential}
\alias{scale_color_discrete_sequential}
\alias{scale_fill_discrete_sequential}
\title{HCL-Based Discrete Sequential Color Scales for ggplot2}
\usage{
scale_colour_discrete_sequential(
  palette = NULL,
  c1 = NULL,
  c2 = NULL,
  cmax = NULL,
  l1 = NULL,
  l2 = NULL,
  h1 = NULL,
  h2 = NULL,
  p1 = NULL,
  p2 = NULL,
  alpha = 1,
  rev = TRUE,
  nmax = NULL,
  order = NULL,
  aesthetics = "colour",
  ...
)

scale_color_discrete_sequential(
  palette = NULL,
  c1 = NULL,
  c2 = NULL,
  cmax = NULL,
  l1 = NULL,
  l2 = NULL,
  h1 = NULL,
  h2 = NULL,
  p1 = NULL,
  p2 = NULL,
  alpha = 1,
  rev = TRUE,
  nmax = NULL,
  order = NULL,
  aesthetics = "colour",
  ...
)

scale_fill_discrete_sequential(..., aesthetics = "fill")
}
\arguments{
\item{palette}{The name of the palette to be used. Run \code{hcl_palettes(type = "sequential")} for available options.}

\item{c1}{Beginning chroma value.}

\item{c2}{Ending chroma value.}

\item{cmax}{Maximum chroma value.}

\item{l1}{Beginning luminance value.}

\item{l2}{Ending luminance value.}

\item{h1}{Beginning hue value.}

\item{h2}{Ending hue value. If set to \code{NA}, generates a single-hue scale.}

\item{p1}{Control parameter determining how chroma should vary (1 = linear, 2 = quadratic, etc.).}

\item{p2}{Control parameter determining how luminance should vary (1 = linear, 2 = quadratic, etc.).}

\item{alpha}{Numeric vector of values in the range \code{[0, 1]} for alpha transparency channel (0 means transparent and 1 means opaque).}

\item{rev}{If \code{TRUE} (default), reverses the order of the colors in the color scale (compared to \code{\link{sequential_hcl}}).}

\item{nmax}{Maximum number of different colors the palette should contain. If not provided, is calculated automatically
from the data.}

\item{order}{Numeric vector listing the order in which the colors should be used. Default is \code{1:nmax}.}

\item{aesthetics}{The ggplot2 aesthetics to which this scale should be applied.}

\item{...}{common discrete scale parameters: \code{name}, \code{breaks}, \code{labels}, \code{na.value}, \code{limits} and \code{guide}. See
\code{\link[ggplot2]{discrete_scale}} for more details.}
}
\description{
Discrete ggplot2 color scales using the color palettes generated by \code{\link{sequential_hcl}}.
}
\details{
If both a valid palette name and palette parameters are provided then the provided palette parameters overwrite the parameters in the
named palette. This enables easy customization of named palettes.

Compared to \code{\link{sequential_hcl}} the ordering of the colors in the sequential ggplot2 scale
are reversed by default (i.e., \code{rev = TRUE}) to be more consistent with ggplot2's own scales such as
\code{\link[ggplot2]{scale_color_brewer}}. For most named palettes this leads to darker and more
colorful colors for larger values on the scale. This is typically the better default on light/white
backgrounds.
}
\examples{
library("ggplot2")

# default colors
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point() + scale_color_discrete_sequential() + theme_classic()

# customization of named palette  
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point() + scale_colour_discrete_sequential(palette = "Reds", nmax = 4, p2 = 1.5) +
  theme_classic()
 
# color scale "Terrain"
ggplot(iris, aes(Sepal.Length, fill = Species)) +
  geom_density(alpha = 0.7) + scale_fill_discrete_sequential(palette = "Terrain") + theme_minimal()
}
