% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{label_repel}
\alias{label_repel}
\title{ggrepel labeling of clusters}
\usage{
label_repel(
  g,
  group_col = "auto",
  x = "x",
  y = "y",
  txt_pt = 3,
  remove_current = "auto",
  layer = "auto",
  ...
)
}
\arguments{
\item{g}{ggplot object or data.frame}

\item{group_col}{column name in data.frame, default to "label" or "group" in ggplot data}

\item{x}{column name in data.frame for x}

\item{y}{column name in data.frame for y}

\item{txt_pt}{text size}

\item{remove_current}{whether to remove current text}

\item{layer}{text layer to remove, defaults to last}

\item{...}{arguments passed to geom_text_repel}
}
\value{
function, if data.frame input, or new ggplot object
}
\description{
ggrepel labeling of clusters
}
\examples{
g <- label_repel(ggplot2::ggplot(mtcars, ggplot2::aes(x = hp, y = wt, color = as.character(cyl))) +
  ggplot2::geom_point(), remove_current = FALSE)
}
