% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02a_histogram_color_clustering.R
\name{getHistList}
\alias{getHistList}
\title{Generate a list of cluster sets for multiple images}
\usage{
getHistList(
  images,
  bins = 3,
  bin.avg = TRUE,
  lower = c(0, 0.55, 0),
  upper = c(0.24, 1, 0.24),
  alpha.channel = TRUE,
  norm.pix = FALSE,
  plotting = FALSE,
  pausing = TRUE,
  hsv = FALSE,
  title = "path",
  img.type = FALSE,
  bounds = c(0, 1)
)
}
\arguments{
\item{images}{Character vector of directories, image paths, or both.}

\item{bins}{Number of bins for each channel OR a vector of length 3 with bins
for each channel. Bins=3 will result in 3^3 = 27 bins; bins=c(2, 2, 3) will
result in 2*2*3=12 bins (2 red, 2 green, 3 blue), etc.}

\item{bin.avg}{Logical. Should the returned color clusters be the average of
the pixels in that bin (bin.avg=\code{TRUE}) or the center of the bin
({FALSE})? If a bin is empty, the center of the bin is returned as the
cluster color regardless.}

\item{lower}{RGB or HSV triplet specifying the lower bounds for background
pixels. Default upper and lower bounds are set to values that work well for
a bright green background (RGB [0, 1, 0]).}

\item{upper}{RGB or HSV triplet specifying the upper bounds for background
pixels. Default upper and lower bounds are set to values that work well for
a bright green background (RGB [0, 1, 0]). Determining these bounds may
take some trial and error, but the following bounds may work for certain
common background colors: \itemize{ \item Black: lower=c(0, 0, 0);
upper=c(0.1, 0.1, 0.1) \item White: lower=c(0.8, 0.8, 0.8); upper=c(1, 1,
1) \item Green: lower=c(0, 0.55, 0); upper=c(0.24, 1, 0.24) \item Blue:
lower=c(0, 0, 0.55); upper=c(0.24, 0.24, 1) } If no background filtering is
needed, set bounds to some non-numeric value (\code{NULL}, \code{FALSE},
\code{"off"}, etc); any non-numeric value is interpreted as \code{NULL}.}

\item{alpha.channel}{Logical. If available, should alpha channel transparency be
used to mask background? See \code{\link{removeBackground}} for more
details.}

\item{norm.pix}{Logical. Should RGB or HSV cluster values be normalized using
\code{\link{normalizeRGB}}?}

\item{plotting}{Logical. Should the histogram generated for each image be
displayed?}

\item{pausing}{Logical. If \code{plotting=T}, should the function pause
between graphing and wait for user to hit \code{[enter]} before continuing?
Useful for data/histogram inspection.}

\item{hsv}{Logical. Should HSV be used instead of RGB?}

\item{title}{String for what the title the plots if plotting is on; defaults
to the image name.}

\item{img.type}{Logical. Should the file extension for the images be retained
when naming the output list elements? If \code{FALSE}, just the image name
is used (so "Heliconius_01.png" becomes "Heliconius_01").}

\item{bounds}{Upper and lower limits for the channels; R reads in images with
intensities on a 0-1 scale, but 0-255 is common.}
}
\value{
A list of \code{\link{getImageHist}} dataframes, 1 per image, named
  by image name.
}
\description{
Applies \code{\link{getImageHist}} to every image in a provided set of image
paths and/or directories containing images.
}
\note{
For every image, the pixels are binned according to the specified bin
breaks. By providing the bounds for the bins rather than letting an algorithm
select centers (as in \code{\link{getKMeansList}}), clusters of nearly
redundant colors are avoided.

So you don't end up with, say, 3 nearly-identical yellow clusters which are
treated as unrelated just because there's a lot of yellow in your image; you
just get a very large yellow cluster and empty non-yellow bins.
}
\examples{
\dontrun{
# Takes >10 seconds if you run all examples
clusterList <- colordistance::getHistList(system.file("extdata",
"Heliconius/Heliconius_B", package="colordistance"), upper = rep(1, 3),
lower = rep(0.8, 3))

clusterList <- colordistance::getHistList(c(system.file("extdata",
"Heliconius/Heliconius_B", package="colordistance"), system.file("extdata",
"Heliconius/Heliconius_A", package="colordistance")), pausing = FALSE,
upper = rep(1, 3), lower = rep(0.8, 3))

clusterList <- colordistance::getHistList(system.file("extdata",
"Heliconius/Heliconius_B", package = "colordistance"), plotting = TRUE,
upper = rep(1, 3), lower = rep(0.8, 3))
}

}
