% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order_methods.R
\name{f_r2}
\alias{f_r2}
\alias{f_r2_pearson}
\alias{f_r2_spearman}
\alias{f_r2_glm_gaussian}
\alias{f_r2_glm_gaussian_poly2}
\alias{f_r2_gam_gaussian}
\alias{f_r2_rpart}
\alias{f_r2_rf}
\title{Association Between a Continuous Response and a Continuous Predictor}
\usage{
f_r2_pearson(df)

f_r2_spearman(df)

f_r2_glm_gaussian(df)

f_r2_glm_gaussian_poly2(df)

f_r2_gam_gaussian(df)

f_r2_rpart(df)

f_r2_rf(df)
}
\arguments{
\item{df}{(required, data frame) with columns:
\itemize{
\item "x": (numeric) continuous predictor.
\item "y" (numeric) continuous response.
}}
}
\value{
numeric: R-squared
}
\description{
These functions take a data frame with two numeric continuous columns "x" (predictor) and "y" (response), fit a univariate model, and return the R-squared of the observations versus the model predictions:
\itemize{

\item \code{f_r2_pearson()}: Pearson's R-squared.

\item \code{f_r2_spearman()}: Spearman's R-squared.

\item \code{f_r2_glm_gaussian()}: Pearson's R-squared of a GLM model fitted with \code{\link[stats:glm]{stats::glm()}}, with formula \code{y ~ s(x)} and family \code{stats::gaussian(link = "identity")}.

\item \code{f_r2_glm_gaussian_poly2()}: Pearson's R-squared of a GLM model fitted with \code{\link[stats:glm]{stats::glm()}}, with formula \code{y ~ stats::poly(x, degree = 2, raw = TRUE)} and family \code{stats::gaussian(link = "identity")}.

\item \code{f_r2_gam_gaussian()}: Pearson's R-squared of a GAM model fitted with \code{\link[mgcv:gam]{mgcv::gam()}}, with formula \code{y ~ s(x)} and family \code{stats::gaussian(link = "identity")}.
\item \code{f_r2_rpart()}: Pearson's R-squared of a Recursive Partition Tree fitted with \code{\link[rpart:rpart]{rpart::rpart()}} with formula \code{y ~ x}.

\item \code{f_r2_rf()}: Pearson's R-squared of a 100 trees Random Forest model fitted with \code{\link[ranger:ranger]{ranger::ranger()}} and formula \code{y ~ x}.

}
}
\examples{

data(vi)

#reduce size to speed-up example
vi <- vi[1:1000, ]

#numeric response and predictor
#to data frame without NAs
df <- data.frame(
  y = vi[["vi_numeric"]],
  x = vi[["swi_max"]]
) |>
  na.omit()

# Continuous response

#Pearson R-squared
f_r2_pearson(df = df)

#Spearman R-squared
f_r2_spearman(df = df)

#R-squared of a gaussian gam
f_r2_glm_gaussian(df = df)

#gaussian glm with second-degree polynomials
f_r2_glm_gaussian_poly2(df = df)

#R-squared of a gaussian gam
f_r2_gam_gaussian(df = df)

#recursive partition tree
f_r2_rpart(df = df)

#random forest model
f_r2_rf(df = df)

#load example data
data(vi)

#reduce size to speed-up example
vi <- vi[1:1000, ]

#continuous response and predictor
#to data frame without NAs
df <- data.frame(
  y = vi[["vi_numeric"]],
  x = vi[["swi_max"]]
) |>
  na.omit()

# Continuous response

#Pearson R-squared
f_r2_pearson(df = df)

#Spearman R-squared
f_r2_spearman(df = df)

#R-squared of a gaussian gam
f_r2_glm_gaussian(df = df)

#gaussian glm with second-degree polynomials
f_r2_glm_gaussian_poly2(df = df)

#R-squared of a gaussian gam
f_r2_gam_gaussian(df = df)

#recursive partition tree
f_r2_rpart(df = df)

#random forest model
f_r2_rf(df = df)

}
\seealso{
Other preference_order_functions: 
\code{\link{f_auc}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_auc}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_auc}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_auc}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_auc}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_auc}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_auc}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}

Other preference_order_functions: 
\code{\link{f_auc}},
\code{\link{f_r2_counts}},
\code{\link{f_v}()},
\code{\link{f_v_rf_categorical}()}
}
\concept{preference_order_functions}
