% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longrun-var.R
\name{getLongRunVar}
\alias{getLongRunVar}
\title{Long-Run Variance}
\usage{
getLongRunVar(u, bandwidth = c("and", "nw"), kernel = c("ba", "bo", "da",
  "pa", "qs", "tr"), demeaning = FALSE, check = TRUE, ...)
}
\arguments{
\item{u}{[\code{numeric} | \code{matrix}]\cr
Data on which to apply the calculation of the long-run variance.}

\item{bandwidth}{[\code{numeric(1)}]\cr
The bandwidth to use for calculating the long-run variance
as a positive intergerish value.}

\item{kernel}{[\code{character(1)}]\cr
The kernel function to use for selecting the bandwidth.
Default is Bartlett kernel (\code{"ba"}), see Details for alternatives.}

\item{demeaning}{[\code{logical}]\cr
Demeaning of the data before the calculation (default is \code{FALSE}).}

\item{check}{[\code{logical}]\cr
Wheather to check (and if necessary convert) the arguments.
See \code{\link{checkVars}} for further information.}

\item{...}{Arguments passed to \code{getBandwidthNW}.}
}
\value{
[\code{list}] with components:
\describe{
  \item{\code{Omega} [\code{matrix}]}{
    Long-run variance matrix}

  \item{\code{Delta} [\code{matrix}]}{
    One-sided long-run variance matrix}

  \item{\code{Sigma} [\code{matrix}]}{
    Variance matrix}
}
}
\description{
This function computes the long-run variance Omega,
the one sided long-run variance Delta (starting with lag 0)
and the variance Sigma from an input matrix of residuals.
}
\details{
The bandwidth can be one of the following:
\itemize{
  \item \code{"ba"}: Bartlett kernel
  \item \code{"bo"}: Bohmann kernel
  \item \code{"da"}: Daniell kernel
  \item \code{"pa"}: Parzen kernel
  \item \code{"qs"}: Quadratic Spectral kernel
  \item \code{"tr"}: Truncated kernel
}
}
\examples{
set.seed(1909)
x <- rnorm(100)
band <- getBandwidthAnd(x, kernel = "ba")
getLongRunVar(x, kernel = "ba", bandwidth = band)
# shorter:
getLongRunVar(x, kernel = "ba", bandwidth = "and")

x2 <- arima.sim(model = list(ar = c(0.7, 0.2)), innov = x, n = 100)
x2 <- cbind(a = x2, b = x2 + rnorm(100))
getLongRunVar(x2, kernel = "ba", bandwidth = "nw")

}
\seealso{
\code{\link{getBandwidth}}
}

