% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{draw.strat}
\alias{draw.strat}
\title{plot the dates and model of chronologically ordered dated depths}
\usage{
draw.strat(
  name = "mystrat",
  set = get("info"),
  structure = set$struc,
  y.scale = "positions",
  strat.dir = "strats",
  cc.dir = c(),
  sep = ",",
  postbomb = FALSE,
  calibrated.ex = c(),
  calibrated.mirror = FALSE,
  calibrated.up = TRUE,
  modelled.ex = c(),
  modelled.mirror = FALSE,
  modelled.up = FALSE,
  BCAD = FALSE,
  threshold = 0.001,
  xtop.lab = c(),
  ytop.lab = c(),
  xbottom.lab = c(),
  ybottom.lab = "position",
  calibrated.col = rgb(0, 0, 0, 0.2),
  calibrated.border = NA,
  calBP.col = rgb(0, 0, 0, 0.2),
  calBP.border = NA,
  modelled.col = rgb(0, 0, 0, 0.5),
  modelled.border = rgb(0, 0, 0, 0.5),
  range.col = "black",
  block.col = rgb(0, 0, 1, 0.05),
  gap.col = "blue",
  gap.pos = 1,
  simulation = FALSE,
  simulation.col = grey(0.5),
  pos.lim = c(),
  age.lim = c(),
  mgp = c(2, 0.7, 0),
  mar.top = c(3, 3, 1, 1),
  mar.bottom = c(3, 3, 0.5, 1),
  heights = c(0.3, 0.7),
  iterations.warning = TRUE,
  min.its = 1000,
  warning.loc = "bottomleft",
  warning.col = "red"
)
}
\arguments{
\item{name}{Name of the stratigraphy dataset. Defaults to \code{"mystrat"}.}

\item{set}{This option reads the 'info' variable, which contains the data and the model output.}

\item{structure}{Information about the structure (e.g., blocks, gaps, dates, undated levels) of the dataset. Filled automatically.}

\item{y.scale}{The scale of the vertical axis of the main plot. This can be the positions of the dated levels (`positions`) or their position order (`dates`).}

\item{strat.dir}{The directory where the folders of the individual stratigraphies live. Defaults to \code{start.dir="strats"}.}

\item{cc.dir}{Directory of calibration curve. Keep empty for the default value.}

\item{sep}{Separator for the fields in the .csv file. Defaults to a comma.}

\item{postbomb}{Negative C-14 ages should be calibrated using a postbomb curve. This could be 1 (northern-hemisphere region 1), 2 (NH region 2), 3 (NH region 3), 4 (southern hemisphere regions 1-2), or 5 (SH region 3).}

\item{calibrated.ex}{Exaggeration of the heights of the calibrated distributions. Calculated automatically by default. Note that more precise dates peak higher than dates with lower precision.}

\item{calibrated.mirror}{Whether or not the individually calibrated (but not the modelled) distributions should be drawn both up and down, quite a bit like fish or swans. Defaults to FALSE.}

\item{calibrated.up}{Whether the calibrated distributions should be drawn upward or downward (the default, resembling the reflections of islands in the sea, or swimming animals if you wish)}

\item{modelled.ex}{Exaggeration of the heights of the age-modelled distributions. Calculated automatically by default. Note that more precise ages peak higher than ages with lower precision.}

\item{modelled.mirror}{Whether or not the age-modelled distributions should be drawn both up and down, quite a bit like fish or swans. Defaults to FALSE.}

\item{modelled.up}{Whether the age-modelled distributions should be drawn downward or upward (the default, resembling islands in the sea)}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{threshold}{Value below which probabilities should not be drawn any more. Defaults to 0.001 of the distribution's peak.}

\item{xtop.lab}{The label for the x-axis of the top panel showing the MCMC run. Defaults to \code{"iterations"}.}

\item{ytop.lab}{The label for the y-axis of the top panel showing the MCMC run. Defaults to \code{"energy"}.}

\item{xbottom.lab}{The label for the x-axis of the bottom panel showing the age-model output. Defaults to \code{"cal BP"} or \code{"BC/AD"}.}

\item{ybottom.lab}{The label for the y-axis of the bottom panel showing the age-model output. Defaults to \code{"position"}.}

\item{calibrated.col}{Colour of the inside of the unmodelled, calibrated ages. Defaults to semi-transparent light grey, \code{rgb(0,0,0,0.5}.}

\item{calibrated.border}{Colour of the border of the unmodelled non-14C ages. Defaults to nothing, NA.}

\item{calBP.col}{Colour of the inside of the unmodelled non-14C ages. Defaults to semi-transparent light grey, \code{rgb(0,0,0,0.5}.}

\item{calBP.border}{Colour of the border of the unmodelled, calibrated ages. Defaults to nothing, NA.}

\item{modelled.col}{Colour of the inside of the modelled ages. Defaults to semi-transparent dark grey, \code{rgb(0,0,0,0.5}.}

\item{modelled.border}{Colour of the border of the modelled ages. Defaults to semi-transparent dark grey, \code{rgb(0,0,0,0.5}.}

\item{range.col}{Colour of the hpd ranges. Defaults to \code{"black"}.}

\item{block.col}{Colour of the field indicating unordered dates within a 'block'. Defaults to light-blue, \code{rgb(0,0,1,.05)}.}

\item{gap.col}{Colour of the diagonal lines and parameters of any gaps.}

\item{gap.pos}{Plotting position of the gap information.}

\item{simulation}{Whether or not the data are part of a simulated stratigraphy.}

\item{simulation.col}{If the data are part of a simulated stratigraphy, the 'true' ages can also be plotted.}

\item{pos.lim}{Limit of the main y-axis.}

\item{age.lim}{Limit of the main x-axis.}

\item{mgp}{Axis text margins (where should titles, labels and tick marks be plotted). Defaults to \code{mgp=c(1.7, .7, .0)}.}

\item{mar.top}{Margins around the top panel. Defaults to \code{mar.top=c(3,3,1,1)}.}

\item{mar.bottom}{Margins around the bottom panel. Defaults to \code{mar.bottom=c(3,3,0.5,1)}.}

\item{heights}{Relative heights of the two panels in the plot. Defaults to 0.3 for the top and 0.7 for the bottom panel.}

\item{iterations.warning}{Whether or not to plot a warning if there are < 3000 iterations, too few for a reliable MCMC run.}

\item{min.its}{The minimum amount of iterations, below which a warning is printed (if \code{iterations.warning=TRUE}). Defaults to 1,000.}

\item{warning.loc}{Location of the warning}

\item{warning.col}{Colour of the warning - defaults to red.}
}
\value{
A plot with two panels showing the MCMC run and the calibrated and modelled ages.
}
\description{
A plot with two panels. The top panel shows the MCMC output. The bottom panel shows the individually calibrated dates (in downward light gray) as well as the modelled ages constrained by chronological ordering (upward dark-grey) and lines with the hpd ranges (black). Any similarity with swimming elephants or island chains is coincidental.
}
\author{
Maarten Blaauw
}
