\name{bal.tab.ps}
\alias{bal.tab.ps}
\alias{bal.tab.mnps}
\alias{bal.tab.iptw}
\alias{bal.tab.ps.cont}
\title{
Balance Statistics for twang Objects
}
\description{
Generates balance statistics for \code{ps}, \code{mnps}, and \code{iptw} objects from \pkg{twang} and for \code{ps.cont} objects from \pkg{WeightIt}. Note that several arguments that used to be documented here are now documented in \link[=options-display]{display options}. They are still available.
}
\usage{
\method{bal.tab}{ps}(ps, 
    stop.method, 
    int = FALSE, 
    poly = 1, 
    distance = NULL, 
    addl = NULL, 
    data = NULL, 
    continuous,  
    binary, 
    s.d.denom, 
    m.threshold = NULL, 
    v.threshold = NULL, 
    ks.threshold = NULL, 
    cluster = NULL, 
    abs = FALSE,
    subset = NULL,
    quick = TRUE, ...)

\method{bal.tab}{mnps}(mnps, 
    stop.method, 
    int = FALSE, 
    poly = 1, 
    distance = NULL, 
    addl = NULL, 
    data = NULL, 
    continuous,  
    binary, 
    s.d.denom, 
    m.threshold = NULL, 
    v.threshold = NULL, 
    ks.threshold = NULL, 
    cluster = NULL, 
    pairwise = TRUE, 
    focal = NULL, 
    abs = FALSE,
    subset = NULL,
    quick = TRUE, ...)
    
\method{bal.tab}{iptw}(iptw, 
    stop.method, 
    int = FALSE, 
    poly = 1, 
    distance.list = NULL, 
    addl.list = NULL, 
    data = NULL, 
    continuous,  
    binary, 
    s.d.denom, 
    m.threshold = NULL, 
    v.threshold = NULL, 
    ks.threshold = NULL, 
    pairwise = TRUE, 
    abs = FALSE, 
    subset = NULL, 
    quick = TRUE, ...)

\method{bal.tab}{ps.cont}(ps.cont, 
    stop.method, 
    int = FALSE, 
    poly = 1, 
    distance = NULL, 
    addl = NULL, 
    data = NULL, 
    r.threshold = NULL, 
    cluster = NULL, 
    abs = FALSE, 
    subset = NULL, 
    quick = TRUE, ...)
}

\arguments{
  \item{ps, mnps, iptw, ps.cont}{
a \code{ps}, \code{mnps}, \code{iptw}, or \code{ps.cont} object; the output of a call to \code{ps()}, \code{mnps()}, or \code{iptw()} from \pkg{twang} or from a call to \code{ps.cont()} from \pkg{WeightIt}.
}
  \item{stop.method}{
a string containing the names of the stopping methods used in the original call to \code{ps()}, \code{mnps()}, \code{iptw()}, or \code{ps.cont()}. Examples include "es.max" or "ks.mean" for \code{ps} and \code{mnps} objects and "p.mean" or "s.max" for \code{ps.cont} objects. \code{bal.tab} will assess balance for the weights created by those stopping methods. The names can be abbreviated as long as the abbreviations are specific enough. If no stopping methods are provided, \code{bal.tab} will default to displaying balance for all available stopping methods. This argument used to be called \code{full.stop.method}, and that name still works.
  }
  \item{int}{
\code{logical} or \code{numeric}; whether or not to include 2-way interactions of covariates included in \code{covs} and in \code{addl}. If \code{numeric}, will be passed to \code{poly} as well. In older versions of \pkg{cobalt}, setting \code{int = TRUE} displayed squares of covariates; to replicate this behavior, set \code{int = 2}.
}
  \item{poly}{
\code{numeric}; the highest polynomial of each continuous covariate to display. For example, if 2, squares of each continuous covariate will be displayed (in addition to the covariate itself); if 3, squares and cubes of each continuous covariate will be displayed, etc. If 1, the default, only the base covariate will be displayed. If \code{int} is numeric, \code{poly} will take on the value of \code{int}.
}
    \item{distance, distance.list}{
optional; either a vector or data.frame containing distance values (e.g., propensity scores) for each unit or a string containing the name of the distance variable in \code{data}. Note that the propensity scores generated by \code{ps()} and \code{iptw()} (but not \code{mnps()} or \code{ps.cont()}) are automatically included.
}
  \item{addl, addl.list}{
an optional data frame or the quoted names of additional covariates for which to present balance. These may be covariates included in the original dataset but not included in the call to \code{ps()}, \code{mnps()}, \code{iptw()}, or \code{ps.cont()}. If variable names are specified, \code{bal.tab()} will look first in the argument to \code{data}, if specified, and next in the input object. For \code{iptw} objects, must be a list of additional covariate values described above, with one list entry per time period.
}
  \item{data}{
an optional data frame containing variables that might be named in arguments to \code{distance}, \code{addl}, and \code{cluster}.
}
  \item{continuous}{
whether mean differences for continuous variables should be standardized ("std") or raw ("raw"). Default "std". Abbreviations allowed. This option can be set globally using \code{\link{set.cobalt.options}}.
}
  \item{binary}{
whether mean differences for binary variables (i.e., difference in proportion) should be standardized ("std") or raw ("raw"). Default "raw". Abbreviations allowed. This option can be set globally using \code{\link{set.cobalt.options}}.
}
  \item{s.d.denom}{
whether the denominator for standardized differences (if any are calculated) should be the standard deviation of the treated group ("treated"), the standard deviation of the control group ("control"), or the pooled standard deviation ("pooled"), computed as the square root of the mean of the group variances. Abbreviations allowed. If not specified, \code{bal.tab()} will use "treated" if the estimand of the call to \code{ps()} is the ATT and "pooled" if the estimand is the ATE.
}
  \item{m.threshold}{
a numeric value for the threshold for mean differences. .1 is recommended. 
}
  \item{v.threshold}{
a numeric value for the threshold for variance ratios. Will automatically convert to the inverse if less than 1.
}
  \item{ks.threshold}{
a numeric value for the threshold for Kolmogorov-Smirnov statistics. Must be between 0 and 1. 
}
  \item{r.threshold}{
a numeric value for the threshold for correlations between covariates and treatment when treatment is continuous.
}
  \item{cluster}{
either a vector containing cluster membership for each unit or a string containing the name of the cluster membership variable in data or the CBPS object. See \code{\link{bal.tab.cluster}} for details.
}
  \item{pairwise}{
whether balance should be computed for pairs of treatments or for each treatment against all others combined. See \code{\link{bal.tab.multi}} for details. 
}
  \item{focal}{
ignored. With multiple categorical treatments, \code{bal.tab()} automatically assigns a focal treatment based on the \code{mnps} object. See \code{\link{bal.tab.multi}} for details.
}
  \item{abs}{
\code{logical}; whether displayed balance statistics should be in absolute value or not. 
}
  \item{subset}{
a \code{logical} vector denoting whether each observation should be included. It should be the same length as the variables in the original call to \code{ps()}, \code{mnps()}, or \code{ps.cont()}. \code{NA}s will be treated as \code{FALSE}. This can be used as an alternative to \code{cluster} to examine balance on subsets of the data.
}
  \item{quick}{
\code{logical}; if \code{TRUE}, will not compute any values that will not be displayed. Set to \code{FALSE} if computed values not displayed will be used later.
}
  \item{...}{
further arguments to control display of output. See \link[=options-display]{display options} for details.
}
}
\details{
\code{bal.tab.ps()} generates a list of balance summaries for the \code{ps} object given, and functions similarly to \code{bal.table()} in \pkg{twang}.

All balance statistics are calculated whether they are displayed by \code{print} or not, unless \code{quick = TRUE}. The threshold values (\code{m.threshold}, \code{v.threshold}, \code{ks.threshold}, and \code{r.threshold}) control whether extra columns should be inserted into the Balance table describing whether the balance statistics in question exceeded or were within the threshold. Including these thresholds also creates summary tables tallying the number of variables that exceeded and were within the threshold and displaying the variables with the greatest imbalance on that balance measure.

}
\value{
For binary point treatments, if clusters are not specified, an object of class \code{"bal.tab"} containing balance summaries for the \code{ps} object. See \code{\link{bal.tab}} for details.

If clusters are specified, an object of class \code{"bal.tab.cluster"} containing balance summaries within each cluster and a summary of balance across clusters. See \code{\link{bal.tab.cluster}} for details.

If \code{mnps()} is used with multiple categorical treatments, an object of class \code{"bal.tab.multi"} containing balance summaries for each pairwise treatment comparison and a summary of balance across pairwise comparisons. See \code{\link{bal.tab.multi}} for details.

If \code{ps.cont()} is used with continuous treatments, means, mean differences, and variance ratios are replaced by (weighted) Pearson correlations between each covariate and treatment. The \code{r.threshold} argument works the same as \code{m.threshold}, \code{v.threshold}, or \code{ks.threshold}, adding an extra column to the balance table output and creating additional summaries for balance tallies and maximum imbalances. All arguments related to the calculation or display of mean differences or variance ratios are ignored. The \code{int}, \code{addl}, \code{un}, \code{distance}, and cluster arguments are still used as described above.

}

\author{
Noah Greifer 
}

\seealso{
\code{\link{bal.tab}} for details of calculations.
\code{\link{bal.tab.cluster}} for more information on clustered data.
\code{\link{bal.tab.multi}} for more information on multiple categorical treatments.
\code{\link{bal.tab.msm}} for more information on longitudinal treatments.
}
\examples{
library(twang); data("lalonde", package = "cobalt")

\dontrun{
## Using ps() for generalized boosted modeling
ps.out <- ps(treat ~ age + educ + married + race +
             nodegree + re74 + re75, data = lalonde, 
             stop.method = c("ks.mean", "es.mean"), 
             estimand = "ATT", verbose = FALSE)
bal.tab(ps.out, stop.method = "es.max", un = TRUE, 
        m.threshold = .1, disp.ks = TRUE)
}
}
