% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalition-probability.R
\name{calculate_prob}
\alias{calculate_prob}
\title{Calculate coalition probability from majority table}
\usage{
calculate_prob(majority_df, coalition, exclude_superior = TRUE, ...)
}
\arguments{
\item{majority_df}{A data frame containing logical values indicating
if the coalitions (columns) have a majority (rows).}

\item{coalition}{The coalition of interest for which superior coalitions
will be obtained by \code{\link[coalitions]{get_superior}}.}

\item{exclude_superior}{Logical. If \code{TRUE}, superior coalitions will
be excluded, otherwise total coalition probabilities will be returned.
Usually it makes sense to exclude superior coalitions.}

\item{...}{Further arguments passed to \code{\link[coalitions]{get_superior}}}
}
\description{
Given a table with simulations in the rows and coalitions in the columns,
this function returns the coalition probabilities for a specified coalition,
by default excluding superior coalitions first
}
\examples{
test_df <- data.frame(
 cdu            = c(rep(FALSE, 9), TRUE),
 cdu_fdp        = c(rep(FALSE, 8), TRUE, TRUE),
 cdu_fdp_greens = c(TRUE, TRUE, rep(FALSE, 6), TRUE, TRUE))
calculate_prob(test_df, "cdu_fdp_greens") # exclude_superior defaults to TRUE
calculate_prob(test_df, "cdu_fdp_greens", exclude_superior=FALSE)
}
