% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat_dna.R
\name{sumstat_dna}
\alias{sumstat_dna}
\title{Summary Statistic: DNA}
\usage{
sumstat_dna(name = "dna", transformation = identity)
}
\arguments{
\item{name}{The name of the summary statistic. When simulating a model,
the value of the statistics are written to an entry of the returned list
with this name. Summary statistic names must be unique in a model.}

\item{transformation}{An optional function for transforming the results
of the statistic. If specified, the results of the transformation are
returned instead of the original values.}
}
\value{
A list of sequences for each locus. Each entries is a
        character matrix decoding the sequences. Each row
        is an individual, and each column is a genetic position.
}
\description{
This summary statistic returns the actual DNA sequences from
finite sites simulations. It can not be
calculated together with other summary statistics or when assuming
an infinite sites mutation model. No outgroup
is needed for it, and the outgroup sequences will also be
returned if present.
}
\examples{
model <- coal_model(5, 1, 10) +
 feat_mutation(5, model = "GTR", gtr_rates = rep(1, 6)) +
 sumstat_dna()
\dontrun{simulate(model)$dna}
}
\seealso{
To create a demographic model: \code{\link{coal_model}}

To calculate this statistic from data: \code{\link{calc_sumstats_from_data}}

Other summary statistics: \code{\link{sumstat_file}},
  \code{\link{sumstat_four_gamete}},
  \code{\link{sumstat_ihh}}, \code{\link{sumstat_jsfs}},
  \code{\link{sumstat_mcmf}},
  \code{\link{sumstat_nucleotide_div}},
  \code{\link{sumstat_omega}},
  \code{\link{sumstat_seg_sites}},
  \code{\link{sumstat_sfs}},
  \code{\link{sumstat_tajimas_d}},
  \code{\link{sumstat_trees}}
}
\concept{summary statistics}
