% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat_file.R
\name{sumstat_file}
\alias{sumstat_file}
\title{Summary Statistic: Files}
\usage{
sumstat_file(folder)
}
\arguments{
\item{folder}{The path to a folder. The files will be created there.}
}
\value{
A character vector containing the files in order in which they
        where created.
}
\description{
This "summmary statistic" returns files with the raw results of
the simulation. Multiple files are returned in case coala needs
multiple calls to simulators to simulate the model. These files
do not contain any post processing of the results done by coala,
e.g. \code{\link{feat_unphased}} and
\code{\link{feat_ignore_singletons}}.
}
\examples{
folder <- tempfile("coala-test")
model <- coal_model(10, 1) +
  feat_mutation(5) +
  sumstat_file(folder)
simulate(model)$file

unlink(folder, recursive = TRUE)  # Clean up
}
\seealso{
To create a demographic model: \code{\link{coal_model}}

To calculate this statistic from data: \code{\link{calc_sumstats_from_data}}

Other summary statistics: \code{\link{sumstat_dna}},
  \code{\link{sumstat_four_gamete}},
  \code{\link{sumstat_ihh}}, \code{\link{sumstat_jsfs}},
  \code{\link{sumstat_mcmf}},
  \code{\link{sumstat_nucleotide_div}},
  \code{\link{sumstat_omega}},
  \code{\link{sumstat_seg_sites}},
  \code{\link{sumstat_sfs}},
  \code{\link{sumstat_tajimas_d}},
  \code{\link{sumstat_trees}}
}

