selpoint <-
function(var,infile,outfile,lon1=0,lat1=0,format="nc",nc34=3){

  start.time <- Sys.time()

# check filename

  filecheck <- checkfile(infile,outfile)

  if (filecheck[[1]]){
    infile <- filecheck[[2]]
    outfile <- filecheck[[3]]    

# define standard names of variables and dimensions

   t_name <- "time"
   t_standard_name = "time"
   t_units = "undefined"
   t_calendar = "undefined"

   nb2_units = "1"

   lat_name = "latitude"
   lat_standard_name = "latitude"
   lat_long_name = "latitude"
   lat_units = "degrees_north"
   lat_axis = "Y"

   lon_name = "longitude"
   lon_standard_name = "longitude"
   lon_long_name = "longitude"
   lon_units = "degrees_east"
   lon_axis = "X"

   v_standard_name = "undefined"
   v_long_name = "undefined"
   v_units = "undefined"
   v__FillValue = "undefined"
   v_missing_value = "undefined"

   info = "Created with the CM SAF R toolbox." 
   var_prec="float"

   att_list <- c("standard_name","long_name","units","_FillValue","missing_value","calendar")
   v_att_list <- c("v_standard_name","v_long_name","v_units","v__FillValue","v_missing_value","v_calendar")
  
# get file information

  cat("get file information", "\n")

  id <- nc_open(infile)

  # get information about dimensions

  dimnames <- names(id$dim)
  dimnames <- dimnames[!dimnames %in% "nb2"] # this can cause trouble

    # check standard_names of dimensions
    for (i in 1:length(dimnames)){
	    sn <- ncatt_get(id,dimnames[i],"standard_name")
	    ln <- ncatt_get(id,dimnames[i],"long_name")
	    if (sn$hasatt){
	      sn <- sn$value
	      if (sn %in% c("longitude","Longitude","Lon","lon"))(lon_name <- dimnames[i])
	      if (sn %in% c("latitude","Latitude","Lat","lat"))(lat_name <- dimnames[i])
	      if (sn=="time"|sn=="Time")(t_name <- dimnames[i])
	    } else {
	        if (ln$hasatt){
	          ln <- ln$value
	          if (ln %in% c("longitude","Longitude","Lon","lon"))(lon_name <- dimnames[i])
	          if (ln %in% c("latitude","Latitude","Lat","lat"))(lat_name <- dimnames[i])
	          if (ln=="time"|ln=="Time")(t_name <- dimnames[i])
	        }
	    }
    }

  for (i in 1:length(dimnames)){
    if (t_name %in% dimnames){
      attnames <- names(id$dim[[i]])
      if ("units" %in% attnames){
	      t_units <- ncatt_get(id,t_name,"units")$value}
      if ("calendar" %in% attnames){
	      t_calendar <- ncatt_get(id,t_name,"calendar")$value}
    }
  }

  # get information about variables
	
  varnames <- names(id$var)
  
    # set variable precision 
    varind   <- which(varnames==var)
    varprec  <- NULL
    varprec  <- id$var[[varind]]$prec
    if (!is.null(varprec)){
      if (varprec %in% c("short", "float", "double", "integer", "char", "byte")){
        (var_prec <- varprec)
      }
    }

   if (var %in% varnames){
    for (i in 1:6){
      att_dum <- ncatt_get(id,var,att_list[i])
      if (att_dum$hasatt){
	      assign(v_att_list[i],att_dum$value)}
    }
   }else{
      nc_close(id)
      stop(cat(paste("Variable ",var," not found! File contains: ",varnames,sep="")),"\n")}

      # get data of first file

	lon <- ncvar_get(id,lon_name)
	lat <- ncvar_get(id,lat_name)
	time1 <- ncvar_get(id,t_name)
	time_len <- length(time1)
	if ("time_bnds" %in% varnames){
	  tbnds1 <- ncvar_get(id,"time_bnds",collapse_degen=FALSE)
	}
	
      # find closest point to target coordinates using sp package

	cat("find closest point to target coordinates", "\n")
	
	dlon <- abs(lon[1]-lon[2])
	dlat <- abs(lat[1]-lat[2])
	
	lon_limit <- which(lon>=(lon1-dlon)&lon<=(lon1+dlon))  
	lat_limit <- which(lat>=(lat1-dlat)&lat<=(lat1+dlat)) 

      if (any(lon_limit)&any(lat_limit)){
  
	lon2 <- lon[lon_limit]
	lat2 <- lat[lat_limit]

	pos <- SpatialPoints(cbind(lon1,lat1), proj4string=CRS("+proj=longlat +datum=WGS84"))
	dum_dist <- 1000
	for (i in 1:length(lon2)){
	  for (j in 1:length(lat2)){
	    dist <- spDistsN1(pos, c(lon2[i],lat2[j]), longlat = FALSE)
	      if (dist<=dum_dist){
		      dum_dist <- dist
		      dumi <- i
		      dumj <- j
	      }
	    }
	  }

	lon_limit <- which(lon==lon2[dumi])  
	lat_limit <- which(lat==lat2[dumj])
      }

   if (any(lon_limit)&any(lat_limit)){

	lon <- lon[lon_limit]
	lat <- lat[lat_limit]
	
	if (var %in% varnames){
	  data1 <- ncvar_get(id,var,start=c(lon_limit,lat_limit,1),count=c(1,1,-1))}

  if (v__FillValue == "undefined"){ 
    v__FillValue = v_missing_value}
  if (v_missing_value == "undefined"){ 
    v_missing_value = v__FillValue}

  nc_close(id)
  
  if (length(time1)==1){
    dummy <- array(NA,dim=c(1,1,1))
    dummy[1,1,1] <- data1
    data1 <- dummy
  }
  
# file output  

  if (format=="nc"){

  # create netcdf

  cat("create netcdf", "\n")  

   # NetCDF format 3 or 4
  
  if (nc34==4){
    nc_format <- as.logical(1)
    compression = 4
  } else {
    nc_format <- as.logical(0)
    compression = NA
  }
 
    dum_fname <- unlist(strsplit(outfile,"\\."))
    if (dum_fname[length(dum_fname)]!="nc")(outfile <- paste(outfile,".nc",sep=""))
    data1[is.na(data1)] <- v_missing_value
    nb2 <- c(0,1)

    x <- ncdim_def(name="lon",units=lon_units,vals=lon)
    y <- ncdim_def(name="lat",units=lat_units,vals=lat)
    t <- ncdim_def(name="time",units=t_units,vals=time1,unlim=TRUE)
    if ("time_bnds" %in% varnames){
      tb <- ncdim_def(name="nb2",units=nb2_units,vals=nb2)
    }

    var1 <- ncvar_def(name=var,units=v_units,dim=list(x,y,t),missval=v_missing_value,
                      prec=var_prec,compression=compression)

    if ("time_bnds" %in% varnames){
      var2 <- ncvar_def(name="time_bnds",units="1",dim=list(tb,t),prec="double")
      vars <- list(var1,var2)
      ncnew <- nc_create(outfile,vars,force_v4=nc_format)

      ncvar_put(ncnew,var1,data1)
      ncvar_put(ncnew,var2,tbnds1)

      ncatt_put(ncnew,var,"standard_name",v_standard_name,prec="text")
      ncatt_put(ncnew,var,"long_name",v_long_name,prec="text")

      ncatt_put(ncnew,"time","standard_name",t_standard_name,prec="text")
      ncatt_put(ncnew,"time","calendar",t_calendar,prec="text")
      ncatt_put(ncnew,"time","bounds","time_bnds",prec="text")

      ncatt_put(ncnew,"lon","standard_name",lon_standard_name,prec="text")
      ncatt_put(ncnew,"lon","long_name",lon_long_name,prec="text")
      ncatt_put(ncnew,"lon","axis",lon_axis,prec="text")

      ncatt_put(ncnew,"lat","standard_name",lat_standard_name,prec="text")
      ncatt_put(ncnew,"lat","long_name",lat_long_name,prec="text")
      ncatt_put(ncnew,"lat","axis",lat_axis,prec="text")

      ncatt_put(ncnew,0,"Info",info,prec="text")

    } else {
      vars <- list(var1)
      ncnew <- nc_create(outfile,vars,force_v4=nc_format)

      ncvar_put(ncnew,var1,data1)

      ncatt_put(ncnew,var,"standard_name",v_standard_name,prec="text")
      ncatt_put(ncnew,var,"long_name",v_long_name,prec="text")

      ncatt_put(ncnew,"time","standard_name",t_standard_name,prec="text")
      ncatt_put(ncnew,"time","calendar",t_calendar,prec="text")

      ncatt_put(ncnew,"lon","standard_name",lon_standard_name,prec="text")
      ncatt_put(ncnew,"lon","long_name",lon_long_name,prec="text")
      ncatt_put(ncnew,"lon","axis",lon_axis,prec="text")

      ncatt_put(ncnew,"lat","standard_name",lat_standard_name,prec="text")
      ncatt_put(ncnew,"lat","long_name",lat_long_name,prec="text")
      ncatt_put(ncnew,"lat","axis",lat_axis,prec="text")

      ncatt_put(ncnew,0,"Info",info,prec="text")

    }

    nc_close(ncnew)
  
  } # end format="nc"

  if (format=="csv"){
    cat("create csv-file", "\n")
    dum_fname <- unlist(strsplit(outfile,"\\."))
    if (dum_fname[length(dum_fname)]!="csv")(outfile <- paste(outfile,".csv",sep=""))
    Data <- data1
    Time <- get_time(t_units,time1)
    dataframe <- data.frame(Time,Data)
    write.table(dataframe,file=outfile,row.names=FALSE,sep=";")    
  }

  } else {cat("WARNING! Coordinates outside of the domain.", "\n")}

  end.time <- Sys.time()
  cat("processing time: ",round(as.numeric(end.time-start.time,units="secs"),digits=2)," s", sep="", "\n")
  } # endif filecheck
}
