% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwiselinterp.R
\name{pwiselinterp}
\alias{pwiselinterp}
\title{Piecewise linear interpolation}
\usage{
pwiselinterp(x, y)
}
\arguments{
\item{x}{a vector of x values}

\item{y}{a vector of y values}
}
\value{
a matrix with the linear function components
}
\description{
Finds a piecewise linear function that interpolates the data points
}
\details{
\code{pwiselinterp} finds a piecewise linear function that
interpolates the data points.  For each x-y ordered pair, there
function finds the unique line interpolating them.  The function will
return a data.frame with three columns.

The column \code{x} is the upper bound of the domain for the given
piece.  The columns \code{m} and \code{b} represent the coefficients
from the y-intercept form of the linear equation, y = mx + b.

The matrix will contain length(x) rows with the first row having m
and b of NA.
}
\examples{
x <- c(5, 0, 3)
y <- c(4, 0, 3)
f <- pwiselinterp(x, y)

}
\seealso{
Other interp: \code{\link{bezier}}, \code{\link{bilinear}},
  \code{\link{cubicspline}}, \code{\link{linterp}},
  \code{\link{nn}}, \code{\link{polyinterp}}

Other algebra: \code{\link{bilinear}},
  \code{\link{cubicspline}}, \code{\link{division}},
  \code{\link{fibonacci}}, \code{\link{horner}},
  \code{\link{isPrime}}, \code{\link{linterp}},
  \code{\link{nthroot}}, \code{\link{polyinterp}},
  \code{\link{quadratic}}
}
