% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\name{comparison_allTogether}
\alias{comparison_allTogether}
\title{Performs all steps in the cell-based comparison procedure.}
\usage{
comparison_allTogether(
  reference,
  target,
  theta = 0,
  numCells = 64,
  maxMissingProp = 0.85
)
}
\arguments{
\item{reference}{an x3p object containing a breech face scan to be treated as
the "reference scan" partitioned into a grid of cells}

\item{target}{an x3p object containing a breech face scan to be treated as the
"target scan" that the reference scan's cells are compared to}

\item{theta}{degrees that the target scan is to be rotated prior extracting
regions.}

\item{numCells}{number of cells to partition the breech face scan into. Must
be a perfect square (49, 64, 81, etc.)}

\item{maxMissingProp}{maximum proportion of missing values allowed for each
cell/region.

data(fadul1.1_processed,fadul1.2_processed)

comparisonDF <- comparison_allTogether(reference = fadul1.1_processed,
target = fadul1.2_processed)

head(comparisonDF)}
}
\value{
a tibble object containing cell indices and the x, y, FFT-based CCF,
and pairwise-complete correlation associated with the comparison between
each cell and its associated target scan region (after rotating the target
scan by theta degrees)
}
\description{
Performs all steps in the cell-based comparison procedure.
}
\examples{

data(fadul1.1_processed,fadul1.2_processed)

cellTibble <- comparison_allTogether(reference = fadul1.1_processed,target = fadul1.2_processed)

head(cellTibble)

}
