      SUBROUTINE DAISY(NN,JPP,X,VALMD,JTMD,JDAT,VTYPE,NDYST,DISV)
CC
CC   PROGRAM FOR CALCULATING DISSIMILARITIES BETWEEN OBJECTS
CC   OR VARIABLES
CC
CC  THE FOLLOWING VECTORS AND MATRICES MUST BE DIMENSIONED IN THE
CC  MAIN PROGRAM :
CC   X(NN,JPP),DISV(1+NN*(NN-1)/2)
CC   JTMD(JPP),VALMD(JPP)
CC   INTEGER (was CHARACTER) VTYPE(JPP)
CC  WHERE :
CC          NN = NUMBER OF OBJECTS
CC          JPP = NUMBER OF VARIABLES USED FOR THE CALCULATIONS
CC
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

      DIMENSION X(NN,JPP),DISV(1+NN*(NN-1)/2),VALMD(JPP),JTMD(JPP)
      INTEGER JDAT,VTYPE(JPP)

CC
CC    VTYPE(J) IS THE TYPE OF VARIABLE J:
CC        = 1(A) FOR AN ASYMMETRIC BINARY VARIABLE
CC        = 2(S) FOR A SYMMETRIC BINARY VARIABLE
CC        = 3(N) FOR A NOMINAL VARIABLE
CC        = 4(O) FOR AN ORDINAL VARIABLE
CC        = 5(I) FOR AN INTERVAL VARIABLE (ADDITIVE)
CC        = 6(T) FOR A RATIO VARIABLE
CC
CC    VECTOR JTMD IS ONLY READ IF THERE ARE MISSING VALUES
CC JTMD(J) = 0 IF VARIABLE J IS BINARY
CC         =-1 IF VARIABLE J IS NOT BINARY AND HAS MISSING VALUES
CC         =+1 IF VARIABLE J IS NOT BINARY AND HAS NO MISSING VALUES
CC

  200 IF(JDAT.EQ.2)GO TO 500

CC
CC   CALCULATION OF THE DISSIMILARITIES
CC
  400 NLK=1
      NBAD=0
      DISV(1)=0.0
      DO 450 L=2,NN
      LA=L-1
      DO 440 K=1,LA
      NLK=NLK+1
      PPA=0.
      DLK=0.
      DO 420 J=1,JPP
      IF(VTYPE(J).EQ.1.OR.VTYPE(J).EQ.2)GO TO 410
      IF(JTMD(J).GE.0)GO TO 405
      IF(X(L,J).EQ.VALMD(J))GO TO 420
      IF(X(K,J).EQ.VALMD(J))GO TO 420
  405 PPA=PPA+1.
      IF(VTYPE(J).EQ.3.AND.X(L,J).NE.X(K,J))DLK=DLK+1.
      IF(VTYPE(J).EQ.1.OR.VTYPE(J).EQ.2.OR.VTYPE(J).EQ.3)
     F GO TO 420
      DLK=DLK+DABS(X(L,J)-X(K,J))
      GO TO 420
  410 IF(X(L,J).NE.0..AND.X(L,J).NE.1.)GO TO 420
      IF(X(K,J).NE.0..AND.X(K,J).NE.1.)GO TO 420
      IF(VTYPE(J).EQ.2.OR.X(L,J).NE.0.OR.X(K,J).NE.0)PPA=PPA+1.
      IF(X(L,J).NE.X(K,J))DLK=DLK+1.
  420 CONTINUE
      IF(PPA.GT.0.5)GO TO 430
      NBAD=NBAD+1
      DISV(NLK)=-1
      GO TO 440
  430 DISV(NLK)=DLK/PPA
  440 CONTINUE
  450 CONTINUE
      GO TO 700

  500 PP=JPP
      NLK=1
      DISV(1)=0.0
      DO 600 L=2,NN
      LSUBT=L-1
      DO 520 K=1,LSUBT
      CLK=0.0
      NLK=NLK+1
      NPRES=0
      DO 530 J=1,JPP
      IF(JTMD(J).GE.0)GOTO 540
      IF(X(L,J).EQ.VALMD(J))GOTO 530
      IF(X(K,J).EQ.VALMD(J))GOTO 530
  540 NPRES=NPRES+1
      IF(NDYST.NE.1)GOTO 550
      CLK=CLK+(X(L,J)-X(K,J))*(X(L,J)-X(K,J))
      GOTO 530
  550 CLK=CLK+DABS(X(L,J)-X(K,J))
  530 CONTINUE
      RPRES=NPRES
      IF(NPRES.NE.0)GOTO 560
      DISV(NLK)=-1.0
      GOTO 520
  560 IF(NDYST.NE.1)GOTO 570
      DISV(NLK)=DSQRT(CLK*(PP/RPRES))
      GOTO 520
  570 DISV(NLK)=CLK*(PP/RPRES)
  520 CONTINUE
  600 CONTINUE

  700 END

