% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createStreamsCpu.R
\name{createStreamsCpu}
\alias{createStreamsCpu}
\title{createStreamsCpu}
\usage{
createStreamsCpu(n = prod(getOption("clrng.Nglobal")))
}
\arguments{
\item{n}{a integer specifying number of streams to create, default is the number of total work items in use.}
}
\value{
an R matrix of streams on CPU.
}
\description{
Create streams stored on the CPU.
}
\examples{
library(clrng)
if (detectGPUs() >= 1) {
  t(createStreamsCpu(n=5))
  ## GPU streams
  myStreamsGpu = vclMatrix(createStreamsCpu(n=4)) }else {
  message("No GPU context available")
}

}
