% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_transfer.R
\name{cloud_drive_download}
\alias{cloud_drive_download}
\title{Download a file from Google Drive to the local project folder}
\usage{
cloud_drive_download(file, root = NULL)
}
\arguments{
\item{file}{Path to a file relative to project folder root. Can contain only
letters, digits, '-', '_', '.', spaces and '/' symbols.}

\item{root}{Google Drive ID or URL of the project root. This serves as the
reference point for all relative paths. When left as \code{NULL}, the root is
automatically derived from the \code{cloudfs.drive} field of the project's
DESCRIPTION file.}
}
\value{
Invisibly returns \code{NULL} after successfully downloading the file.
}
\description{
Retrieves a file from the project's Google Drive folder and
saves it to the local project folder, maintaining the original folder
structure.
}
\details{
Google Drive file structure is different from the usual file
structure like e.g. on Linux or Windows. A folder on Google Drive can have
two or more child folders with the same name. Google Drive marks files and
folders with so-called id values to distinguish between them. These values
are always unique. You can see them in browser URL for example. The concept
of "name" is in the first place for convenience of the end user.

In such a setup a relative file path may correspond to multiple files or
folders. This function however works under assumption that the relative
path you pass to it defines strictly one object. If there's any ambiguity
it throws an error.
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# downloads toy_data/demo.csv from project's Google Drive folder 
# (provided it exists) and saves it to local 'toy_data' folder
cloud_drive_download("toy_data/demo.csv")

# clean up
unlink("toy_data", recursive = TRUE)
\dontshow{\}) # examplesIf}
}
