/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceAsync;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest;
import com.amazonaws.services.simpleemail.model.GetSendQuotaRequest;
import com.amazonaws.services.simpleemail.model.GetSendQuotaResult;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsResult;
import com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest;
import com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesResult;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.services.simpleemail.model.SendEmailResult;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleEmailServiceAsyncClient
extends AmazonSimpleEmailServiceClient
implements AmazonSimpleEmailServiceAsync {
    private ExecutorService executorService;

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonSimpleEmailServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<GetSendQuotaResult> getSendQuotaAsync(final GetSendQuotaRequest getSendQuotaRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSendQuotaResult>(){

            @Override
            public GetSendQuotaResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.getSendQuota(getSendQuotaRequest);
            }
        });
    }

    @Override
    public Future<ListVerifiedEmailAddressesResult> listVerifiedEmailAddressesAsync(final ListVerifiedEmailAddressesRequest listVerifiedEmailAddressesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListVerifiedEmailAddressesResult>(){

            @Override
            public ListVerifiedEmailAddressesResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.listVerifiedEmailAddresses(listVerifiedEmailAddressesRequest);
            }
        });
    }

    @Override
    public Future<GetSendStatisticsResult> getSendStatisticsAsync(final GetSendStatisticsRequest getSendStatisticsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSendStatisticsResult>(){

            @Override
            public GetSendStatisticsResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.getSendStatistics(getSendStatisticsRequest);
            }
        });
    }

    @Override
    public Future<SendEmailResult> sendEmailAsync(final SendEmailRequest sendEmailRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendEmailResult>(){

            @Override
            public SendEmailResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.sendEmail(sendEmailRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteVerifiedEmailAddressAsync(final DeleteVerifiedEmailAddressRequest deleteVerifiedEmailAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleEmailServiceAsyncClient.this.deleteVerifiedEmailAddress(deleteVerifiedEmailAddressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> verifyEmailAddressAsync(final VerifyEmailAddressRequest verifyEmailAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleEmailServiceAsyncClient.this.verifyEmailAddress(verifyEmailAddressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<SendRawEmailResult> sendRawEmailAsync(final SendRawEmailRequest sendRawEmailRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendRawEmailResult>(){

            @Override
            public SendRawEmailResult call() throws Exception {
                return AmazonSimpleEmailServiceAsyncClient.this.sendRawEmail(sendRawEmailRequest);
            }
        });
    }
}

