/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui.networkspec;

import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.norbl.cbp.ppe.AmiPPE;
import com.norbl.cbp.ppe.Ec2InstanceType;
import com.norbl.cbp.ppe.NetworkSpec;
import com.norbl.cbp.ppe.NiM;
import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.cbp.ppe.gui.InProgressFrame;
import com.norbl.cbp.ppe.gui.networkspec.AmiChoice;
import com.norbl.cbp.ppe.gui.networkspec.AvailabilityZoneChoice;
import com.norbl.cbp.ppe.gui.networkspec.Choice;
import com.norbl.cbp.ppe.gui.networkspec.ChoiceSet;
import com.norbl.cbp.ppe.gui.networkspec.InstanceTypeChoice;
import com.norbl.cbp.ppe.gui.networkspec.KeyPairChoice;
import com.norbl.cbp.ppe.gui.networkspec.LabeledTextFieldCC;
import com.norbl.cbp.ppe.gui.networkspec.NInstancesChoice;
import com.norbl.cbp.ppe.gui.networkspec.NetworkNameChoice;
import com.norbl.cbp.ppe.gui.networkspec.SecurityGroupChoice;
import com.norbl.cbp.ppe.gui.networkspec.SlotsPerHostChoice;
import com.norbl.cbp.ppe.gui.networkspec.SpecErrorFrame;
import com.norbl.cbp.ppe.gui.networkspec.SpotPriceChoice;
import com.norbl.util.ExceptionHandler;
import com.norbl.util.gui.GuiUtil;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class NetworkSpecGui
implements ActionListener {
    public static final String CANCEL = "cancel";
    public static final String FINISH = "finish";
    PPEManager ppeManager;
    Class amiChoiceClass;
    Class guiFrameClass;
    Constructor guiFrameCons;
    Constructor amiChoiceConstructor;
    String networkName;
    List<String> keypairNames;
    JFrame networkSpecFrame;
    private SpecErrorFrame sef;
    private boolean notDone;
    private boolean specComplete;
    ChoiceSet instanceTypeChoices;
    ChoiceSet amiChoices;
    ChoiceSet availabilityZoneChoices;
    ChoiceSet securityGroupChoices;
    ChoiceSet keyPairsChoices;
    SpotPriceChoice spotPriceChoice;
    NInstancesChoice nInstancesChoice;
    NetworkNameChoice networkNameChoice;
    SlotsPerHostChoice slotsPerHostChoice;
    private HashMap<String, Choice> actionChoiceHt;
    private static int lastIDNumber = -1;
    private static String OTP_CANCEL = "Cancel";
    private static String OTP_MODIFY_SPEC = "Modify spec";
    private static String OTP_GO = "Create the network";

    public NetworkSpecGui(PPEManager ppeManager, Class amiChoiceClass, Class guiFrameClass, String networkName) throws Exception {
        this.ppeManager = ppeManager;
        this.amiChoiceClass = amiChoiceClass;
        this.networkName = networkName;
        this.amiChoiceConstructor = amiChoiceClass.getConstructor(AmiPPE.class);
        this.guiFrameCons = guiFrameClass.getConstructor(NetworkSpecGui.class);
        this.keypairNames = ppeManager.ec2w.getKeypairNames();
        this.notDone = true;
        this.createChoices();
    }

    public boolean fillSpec() {
        this.specComplete = false;
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    NetworkSpecGui.this.networkSpecFrame = (JFrame)NetworkSpecGui.this.guiFrameCons.newInstance(NetworkSpecGui.this);
                }
                catch (Exception x) {
                    GuiUtil.exceptionMessage(x.getCause());
                }
                finally {
                    InProgressFrame.end();
                }
            }
        });
        while (this.notDone) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.specComplete;
    }

    public NetworkSpec choicesToNetworkSpec() {
        KeyPairChoice kp;
        AvailabilityZoneChoice az;
        AmiChoice ami;
        NetworkSpec s = new NetworkSpec();
        InstanceTypeChoice instanceType = (InstanceTypeChoice)this.instanceTypeChoices.getSelected();
        if (instanceType != null) {
            s.instanceType = instanceType.instanceType.instanceType;
        }
        if ((ami = (AmiChoice)this.amiChoices.getSelected()) != null) {
            s.imageID = (String)ami.getValue();
        }
        s.availabilityZone = (az = (AvailabilityZoneChoice)this.availabilityZoneChoices.getSelected()) != null ? az.getLabel() : "Use any zone.";
        SecurityGroupChoice sg = (SecurityGroupChoice)this.securityGroupChoices.getSelected();
        if (sg != null) {
            s.securityGroupName = (String)sg.getValue();
        }
        if (s.securityGroupName.equals("default")) {
            s.securityGroupName = null;
        }
        if ((kp = (KeyPairChoice)this.keyPairsChoices.getSelected()) != null) {
            s.keyName = (String)kp.getValue();
        }
        if (this.spotPriceChoice.selected) {
            s.useSpotInstances = true;
            s.spotPrice = this.spotPriceChoice.getPrice();
        } else {
            s.useSpotInstances = false;
        }
        s.nInstances = this.nInstancesChoice.getNInstances();
        s.networkName = (String)this.networkNameChoice.getValue();
        s.slotsPerHost = this.slotsPerHostChoice.getNSlots();
        String uid = PPEManager.paramsEc2.uid;
        if (uid == null) {
            uid = (String)this.ppeManager.paramHt.get(ParamsEc2.ParamName.uid.toString());
        }
        if (uid == null) {
            uid = "nil";
        }
        s.userData = uid;
        return s;
    }

    private void createChoices() throws Exception {
        this.actionChoiceHt = new HashMap();
        this.instanceTypeChoices = new ChoiceSet();
        for (Ec2InstanceType eit : this.ppeManager.instanceTypes) {
            this.instanceTypeChoices.add(this.register(new InstanceTypeChoice(eit), this.instanceTypeChoices));
        }
        this.amiChoices = new ChoiceSet();
        for (AmiPPE ami : this.ppeManager.amis) {
            AmiChoice c = this.createAmiChoice(ami);
            c.setEnabled(ami.isUsableReBilling(PPEManager.paramsEc2));
            this.amiChoices.add(this.register(c, this.amiChoices));
        }
        this.amiChoices.add(this.register(this.createAmiChoice(null), this.amiChoices));
        this.availabilityZoneChoices = new ChoiceSet();
        this.availabilityZoneChoices.add(this.register(new AvailabilityZoneChoice(null), this.availabilityZoneChoices));
        for (AvailabilityZone az : this.ppeManager.availabilityZones) {
            this.availabilityZoneChoices.add(this.register(new AvailabilityZoneChoice(az), this.availabilityZoneChoices));
        }
        this.securityGroupChoices = new ChoiceSet();
        this.securityGroupChoices.add(this.register(new SecurityGroupChoice(SecurityGroupChoice.Type.defaultGroup), this.securityGroupChoices));
        this.securityGroupChoices.add(this.register(new SecurityGroupChoice(SecurityGroupChoice.Type.other), this.securityGroupChoices));
        this.keyPairsChoices = new ChoiceSet();
        for (String kp : this.keypairNames) {
            this.keyPairsChoices.add(this.register(new KeyPairChoice(kp), this.keyPairsChoices));
        }
        this.keyPairsChoices.add(this.register(new KeyPairChoice(), this.keyPairsChoices));
        this.spotPriceChoice = (SpotPriceChoice)this.setup(new SpotPriceChoice(), true);
        this.nInstancesChoice = (NInstancesChoice)this.setup(new NInstancesChoice());
        this.slotsPerHostChoice = (SlotsPerHostChoice)this.setup(new SlotsPerHostChoice());
        this.networkNameChoice = this.networkName != null ? (NetworkNameChoice)this.setup(new NetworkNameChoice(this.networkName)) : (NetworkNameChoice)this.setup(new NetworkNameChoice(NiM.createUniqueDefaultNetworkName()));
    }

    private AmiChoice createAmiChoice(AmiPPE ami) throws Exception {
        return (AmiChoice)this.amiChoiceConstructor.newInstance(ami);
    }

    private String nextChoiceID() {
        int x = ++lastIDNumber;
        return "ac_" + Integer.toString(x);
    }

    private Choice setup(Choice c, boolean setLabelTextBold) {
        c.createCC();
        if (c.cc instanceof LabeledTextFieldCC && setLabelTextBold) {
            ((LabeledTextFieldCC)c.cc).setLabelTextBold();
        }
        c.cc.addActionListener(this);
        c = this.register(c, null);
        c.cc.setActionCommand(c.ID);
        return c;
    }

    private Choice setup(Choice c) {
        return this.setup(c, false);
    }

    private Choice register(Choice c, ChoiceSet parent) {
        c.setParentChoiceSet(parent);
        c.setID(this.nextChoiceID());
        this.actionChoiceHt.put(c.ID, c);
        return c;
    }

    private void updateRe(Choice cx) {
        if (cx.parentChoiceSet != null) {
            for (Choice c : cx.parentChoiceSet) {
                c.setSelected(false);
            }
        }
        cx.setSelected(true);
        if (cx instanceof InstanceTypeChoice) {
            this.imposeConformityReInstanceTypeChoice((InstanceTypeChoice)cx);
            this.slotsPerHostChoice.setNSlots(((InstanceTypeChoice)cx).instanceType.nCores);
        }
        if (cx instanceof SpotPriceChoice) {
            SpotPriceChoice sc = (SpotPriceChoice)cx;
            sc.setSelected(sc.cc.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        new Thread(new ActionRunner(ev.getActionCommand())).start();
    }

    private void getOkToProceed() {
        this.networkSpecFrame.setVisible(false);
        int idx = JOptionPane.showOptionDialog(this.networkSpecFrame, this.toHtmlString(), "Create ec2 network", 1, -1, null, new Object[]{OTP_CANCEL, OTP_MODIFY_SPEC, OTP_GO}, null);
        if (idx == 0) {
            this.specComplete = false;
            this.notDone = false;
            this.networkSpecFrame.dispose();
        } else if (idx == 1) {
            this.networkSpecFrame.setVisible(true);
            this.notDone = true;
        } else if (idx == 2) {
            this.specComplete = true;
            this.notDone = false;
            this.networkSpecFrame.dispose();
        } else {
            this.specComplete = false;
            this.notDone = false;
            Exception x = new Exception("idx=" + idx);
            ExceptionHandler.display(x);
            this.networkSpecFrame.dispose();
        }
    }

    private String checkSpec() {
        String ni;
        KeyPairChoice kp;
        SecurityGroupChoice sg;
        AmiChoice ami;
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<String> invalid = new ArrayList<String>();
        InstanceTypeChoice instanceType = (InstanceTypeChoice)this.instanceTypeChoices.getSelected();
        if (instanceType == null) {
            missing.add("Instance type");
        }
        if ((ami = (AmiChoice)this.amiChoices.getSelected()) == null) {
            missing.add("AMI ID");
        }
        if ((sg = (SecurityGroupChoice)this.securityGroupChoices.getSelected()) == null) {
            missing.add("Security group");
        }
        if ((kp = (KeyPairChoice)this.keyPairsChoices.getSelected()) == null || kp.getValue() == null) {
            missing.add("Keypair");
        }
        if (this.spotPriceChoice.selected) {
            String x = (String)this.spotPriceChoice.getValue();
            if (this.isEmpty(x)) {
                missing.add("Spot price");
            } else if (this.isInvalidPrice(x)) {
                invalid.add("'" + x + "' is not a valid price.");
            }
        }
        if (this.isEmpty(ni = (String)this.nInstancesChoice.getValue())) {
            missing.add("n instances");
        } else if (this.isInvalidNInstances(ni)) {
            invalid.add("'" + ni + "' is not a valid number of instances.");
        }
        String networkName = (String)this.networkNameChoice.getValue();
        if (this.isEmpty(networkName)) {
            missing.add("Network name");
        }
        if (this.slotsPerHostChoice.getValue() == null) {
            missing.add("Slots per host");
        }
        if (missing.size() < 1 && invalid.size() < 1) {
            return null;
        }
        StringBuilder s = new StringBuilder("<html>\n");
        if (missing.size() > 0) {
            s.append("The following required parameters were not specified:<ul>\n");
            for (String m : missing) {
                s.append("<li>" + m + "</li>\n");
            }
            s.append("</ul>\n");
        }
        if (invalid.size() > 0) {
            s.append("<br>");
            s.append("Invalid values:<ul>\n");
            for (String i : invalid) {
                s.append("<li>" + i + "</li>\n");
            }
            s.append("</ul>\n");
        }
        s.append("</html>");
        return s.toString();
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() < 1;
    }

    private boolean isInvalidPrice(String s) {
        try {
            double p = Double.parseDouble(s);
            return p <= 0.0;
        }
        catch (NumberFormatException nfx) {
            return true;
        }
    }

    private boolean isInvalidNInstances(String s) {
        try {
            double n = Integer.parseInt(s);
            return n <= 0.0;
        }
        catch (NumberFormatException nfx) {
            return true;
        }
    }

    private String toHtmlString() {
        NetworkSpec ns = this.choicesToNetworkSpec();
        if (!ns.isComplete()) {
            throw new RuntimeException("Incomplete NetworkSpec:<br>" + ns.listMissingParams());
        }
        StringBuilder s = new StringBuilder("<html><b>ec2 network specification:</b><br><ul>");
        s.append("<li>Instance type:  " + ns.instanceType + "</li>");
        s.append("<li>AMI ID:  " + ns.imageID + "</li>");
        s.append("<li>Availability zone: " + ns.availabilityZone + "</li");
        s.append("<li>Security group:  " + ns.securityGroupName + "</li>");
        s.append("<li>Keypair:  " + ns.keyName + "</li>");
        if (ns.useSpotInstances) {
            s.append("<li>Spot price:  " + ns.spotPrice + "</li>");
        }
        s.append("<li>N instances:  " + ns.nInstances + "</li>");
        s.append("<li>Slots per host:  " + ns.slotsPerHost + "</li>");
        s.append("</ul><br><b>Please note that if you proceed you will incur charges from Amazon for ec2 instances.</b><br><br></html>");
        return s.toString();
    }

    private void imposeConformityReInstanceTypeChoice(InstanceTypeChoice c) {
        if (!c.cc.getRadioButton().isSelected()) {
            return;
        }
        if (c.instanceType.isHvm()) {
            this.imposeHvmConformity(c);
        } else if (c.instanceType.isPv()) {
            this.imposeParavirtualConformity(c);
        } else {
            throw new RuntimeException("Bad instance type=" + c.instanceType.instanceType.toString() + " " + (Object)((Object)c.instanceType.vt));
        }
    }

    private void imposeHvmConformity(InstanceTypeChoice selected) {
        for (Choice c : this.amiChoices) {
            AmiChoice a = (AmiChoice)c;
            if (a.ami == null) continue;
            if (!a.ami.isUsableReBilling(PPEManager.paramsEc2) || a.usesParavirtual()) {
                a.cc.setSelected(false);
                a.cc.setEnabled(false);
                continue;
            }
            a.cc.setEnabled(true);
        }
    }

    private void imposeParavirtualConformity(Choice selected) {
        for (Choice c : this.amiChoices) {
            AmiChoice a = (AmiChoice)c;
            if (a.ami == null) continue;
            if (!a.ami.isUsableReBilling(PPEManager.paramsEc2) || a.usesHvm()) {
                a.cc.setSelected(false);
                a.cc.setEnabled(false);
                continue;
            }
            a.cc.setEnabled(true);
        }
        this.spotPriceChoice.setEnabled(true);
    }

    private class ActionRunner
    implements Runnable {
        String cmd;

        ActionRunner(String cmd) {
            this.cmd = cmd;
        }

        @Override
        public void run() {
            if (NetworkSpecGui.this.sef != null) {
                NetworkSpecGui.this.sef.dispose();
            }
            if (this.cmd.equals(NetworkSpecGui.CANCEL)) {
                NetworkSpecGui.this.networkSpecFrame.dispose();
                NetworkSpecGui.this.specComplete = false;
                NetworkSpecGui.this.notDone = false;
            } else if (this.cmd.equals(NetworkSpecGui.FINISH)) {
                String message = NetworkSpecGui.this.checkSpec();
                if (message != null) {
                    if (NetworkSpecGui.this.sef != null) {
                        NetworkSpecGui.this.sef.dispose();
                    }
                    NetworkSpecGui.this.sef = new SpecErrorFrame(message);
                    NetworkSpecGui.this.sef.create();
                } else {
                    NetworkSpecGui.this.getOkToProceed();
                }
            } else {
                Choice c = (Choice)NetworkSpecGui.this.actionChoiceHt.get(this.cmd);
                if (c != null) {
                    NetworkSpecGui.this.updateRe(c);
                }
            }
        }
    }

    public static enum CmdType {
        choice,
        cancel,
        forward,
        nil;

    }
}

