/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LabeledTextField
extends JPanel {
    static Dimension TEXT_FIELD_SZ = new Dimension(100, 24);
    static Dimension MAX_TEXT_FIELD_SZ = new Dimension(300, 24);
    static int WIDTH_PREF = 100;
    static int WIDTH_MAX = 300;
    JLabel label;
    JTextField textField;

    public LabeledTextField(int minWidth, int maxWidth) {
        this.setLayout(new BoxLayout(this, 0));
        this.label = new JLabel();
        this.textField = new JTextField();
        this.label.setText("XXXXX");
        this.setWidthsLabel(minWidth);
        this.add(this.label);
        this.setWidths(minWidth, maxWidth);
        this.add(this.textField);
        this.setEnabled(true);
    }

    public void setLabelTextBold() {
        Font f = this.label.getFont();
        f = new Font(f.getFontName(), 1, f.getSize());
        this.label.setFont(f);
    }

    public LabeledTextField(String labelText, int minWidth, int maxWidth) {
        this(minWidth, maxWidth);
        this.label.setText(labelText);
    }

    public LabeledTextField() {
        this(WIDTH_PREF, WIDTH_MAX);
    }

    public LabeledTextField(String labelText) {
        this(labelText, WIDTH_PREF, WIDTH_MAX);
    }

    public void setWidths(int minWidth, int maxWidth) {
        Dimension pref = new Dimension(minWidth, 24);
        Dimension max = new Dimension(maxWidth, 24);
        this.textField.setMaximumSize(max);
        this.textField.setMinimumSize(pref);
        this.textField.setPreferredSize(pref);
    }

    public void setWidthsLabel(int minWidth) {
        int maxWidth = 140;
        Dimension pref = new Dimension(minWidth, 24);
        Dimension max = new Dimension(maxWidth, 24);
        this.label.setMaximumSize(max);
        this.label.setMinimumSize(pref);
        this.label.setPreferredSize(pref);
    }

    Dimension getTextDim(int width) {
        return new Dimension(width, 24);
    }

    public void setVal(String val) {
        this.textField.setText(val);
    }

    public String getVal() {
        return this.textField.getText();
    }

    public String getKey() {
        return this.label.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public void addActionListener(ActionListener actionListener) {
        this.textField.addActionListener(actionListener);
    }
}

