% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_cutoff.R
\name{check_cutoff}
\alias{check_cutoff}
\title{Check the Clinical Significance Cutoff Based on Population Descriptives}
\usage{
check_cutoff(
  object = NULL,
  m_clinical,
  sd_clinical,
  m_functional = NA,
  sd_functional = NA,
  type = c("a", "b", "c"),
  better_is = c("lower", "higher"),
  resolution = 300
)
}
\arguments{
\item{object}{An object of class clinisig. This is optional and can be used
to visualize cutoffs after conducting a clinical significance analysis.}

\item{m_clinical}{Mean of clinical population}

\item{sd_clinical}{SD of clinical population}

\item{m_functional}{M of functional population}

\item{sd_functional}{SD of functional population}

\item{type}{Cutoff type. Available are \code{"a"}, \code{"b"}, and \code{"c"}. Defaults to
\code{"a"} (see details for further information in which cutoff to choose)}

\item{better_is}{Which direction means a better outcome for the employed
outcome? Available are
\itemize{
\item \code{"lower"} (lower outcome scores are desirable, the default) and
\item \code{"higher"} (higher outcome scores are desirable)
}}

\item{resolution}{Curve resolution (number of points to be drawn). This may
improve smoothness of highly peaked curves.}
}
\value{
A ggplot2
}
\description{
Check the Clinical Significance Cutoff Based on Population Descriptives
}
\examples{
# Check cutoff with manually specified values
check_cutoff(m_clinical = 40, sd_clinical = 12, m_functional = 10, sd_functional = 12)


# Or check the cutoff after you conducted a clinical significance analysis
results <- jacobson_1989 \%>\%
  clinical_significance(
    id = subject,
    time = time,
    outcome = gds,
    pre = "pre",
    reliability = 0.80,
    m_functional = 30,
    sd_functional = 7,
    type = "c"
  )

check_cutoff(results)
}
