% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chelsa.R
\name{chelsa}
\alias{chelsa}
\title{Download CHELSA climate data}
\usage{
chelsa(output_dir = NULL, var = "all", quiet = FALSE, ...)
}
\arguments{
\item{output_dir}{Character (e.g., \code{"../Desktop/chelsa"}). Pathway to where
the data will be stored.}

\item{var}{Character. If supplied will download a subset of the climate data.
Must be one of \code{"all"} (default), \code{"prec"}, \code{"tmax"}, \code{"tmin"} or \code{"tmean"}
to download the corresponding climate data.}

\item{quiet, \dots}{Arguments to control a download from the Internet
\code{download.file()}.}
}
\value{
Returns four subfolders named prec, tmax, tmin and tmean. Each folder
contains 12 GeoTiff (.tif) files, one for each month of the year for the time
period 1981–2010. Each of the files are downloaded at a spatial
resolution of 30 arc seconds (~1 km  sq.). The precipitation folder
contains average monthly precipitation (mm). The tmax folder contains maximum
monthly temperature. The tmin folder contains minimum monthly temperature.
The tmean folder contains the average monthly temperature. The unit of
measure for temperature is in °C.
}
\description{
\code{chelsa()} downloads the CHELSA (Climatologies at high resolution for the
earth’s land surface areas) V2.1 data of temperature and precipitation at a
resolution of 30 arc sections.
}
\examples{
\donttest{

# Download time will depend on the size of the area you wish to access
# climate data for and your internet connection speed.

# Create temporary file
temp_path <- tempfile()

# Download the WorldClim data
chelsa(
  output_dir = temp_path
)

# Reset user options
unlink(file.path(temp_path))

# Note that unlike worldclim() we do not specify the location argument
# because it is not yet possible to extract smaller tile sections

}

}
\references{
Karger,  D.N., Conrad, O., Bőhner, J., Kawohl, T.,
Kreft, H., Soria-Auza, R.W. et al (2017) Climatologies at high resolution for
the earth’s land surface areas. \emph{Scientific Data}, 4, 170122.
\doi{10.1038/sdata.2017.122}

Karger, D.N., Conrad, O., Bőhner, J., Kawohl, T., Kreft, H.,
Soria-Auza, R.W. et al. (2021) Climatologies at high resolution for the
earth’s land surface areas. \emph{EnviDat}. \doi{10.16904/envidat.228.v2.1}
}
\seealso{
Downloading from WorldClim V2.1 \code{\link[=worldclim]{worldclim()}} or a more convenient
function for other climate and elevation data \code{\link[=ce_download]{ce_download()}}.
}
\author{
James L. Tsakalos and Martin R. Smith
}
