% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tools.R
\name{ggstripes}
\alias{ggstripes}
\title{Warming stripes graph}
\usage{
ggstripes(
  data,
  plot_type = c("background", "stripes", "trend", "animation"),
  plot_title = "",
  ...
)
}
\arguments{
\item{data}{a data.frame with date(year) and temperature(temp) variables.}

\item{plot_type}{plot type (whith labels, background, stripes with line trend and animation)}

\item{plot_title}{character string to be used for the graph title.}

\item{...}{further arguments passed to \code{\link[ggplot2]{theme}}.}
}
\value{
a \code{ggplot} object
}
\description{
Plot diferent "climate stripes" or "warming stripes" using \pkg{ggplot2}. This graphics are visual representations of the change in temperature as measured in each location over the past 70-100+ years. Each stripe represents the temperature in that station averaged over a year.
}
\note{
"Warming stripes" charts are a conceptual idea of Professor Ed Hawkins (University of Reading) and are specifically designed to be as simple as possible and alert about risks of climate change. For more details see #ShowYourStripes: \url{https://showyourstripes.info/}.
}
\examples{
\donttest{
ggstripes(data, plot_type = "background")
}

}
\seealso{
\code{\link[ggplot2]{theme}} for more possible arguments to pass to \code{ggstripes}.
}
