% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climaemet_main.R
\name{climatestripes_station}
\alias{climatestripes_station}
\title{Station climate stripes graph}
\usage{
climatestripes_station(
  station,
  apikey,
  start = 1950,
  end = 2020,
  with_labels = c("yes, no")
)
}
\arguments{
\item{station}{Character string as station identifier code (see \code{\link{aemet_stations}}).}

\item{apikey}{Character string as personal API key (see \url{https://opendata.aemet.es/centrodedescargas/obtencionAPIKey}).}

\item{start}{Numeric value as start year (format: \%Y).}

\item{end}{Numeric value as end year (format: \%Y).}

\item{with_labels}{Character string as yes/no. Indicates whether to use labels for the graph or not.}
}
\value{
a plot.
}
\description{
Plot climate stripes graph for a station
}
\examples{
\dontrun{
climatestripes_station(station, apikey, with_labels = "yes")
}

}
