% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaluation.r
\name{mcEvaluate}
\alias{mcEvaluate}
\title{Evaluates the number of occurrences of predicted next clicks}
\usage{
mcEvaluate(mc, startPattern, testCLS)
}
\arguments{
\item{mc}{a markovchain object (this should have been built from a set of training data)}

\item{startPattern}{the starting pattern we want to predict next click on, and evaluate observed occurrences in test data.}

\item{testCLS}{clickstream object with test data}
}
\description{
Evaluates the number of occurrences of predicted next clicks vs. total number of starting pattern occurrences
in a given clickstream. The predicted next click can be a markov chain of any order.
}
\examples{
training <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
              "User2,i,c,i,c,c,c,d",
              "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
              "User4,c,c,p,c,d")

test <- c("User1,h,h,h,h,c,c,p,p,h,c,p,p,c,p,p,o",
          "User2,i,c,i,c,c,c,d",
          "User4,c,c,c,c,d,c,c,c,c")

csf <- tempfile()
writeLines(training, csf)
trainingCLS <- readClickstreams(csf, header = TRUE)
unlink(csf)

csf <- tempfile()
writeLines(test, csf)
testCLS <- readClickstreams(csf, header = TRUE)
unlink(csf)

mc <- fitMarkovChain(trainingCLS, order = 1)
startPattern <- new("Pattern", sequence = c("c","c")) 
res <- mcEvaluate(mc, startPattern, testCLS)
res
}
\author{
Theo van Kraay \email{theo.vankraay@hotmail.com}
}
