% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Clickstream.r
\name{predict.ClickstreamClusters}
\alias{predict.ClickstreamClusters}
\title{Predicts the Cluster for a Given Pattern Object}
\usage{
\method{predict}{ClickstreamClusters}(object, pattern, ...)
}
\arguments{
  \item{object}{A \code{ClickstreamClusters} object
  containing the clusters. \code{ClickstreamClusters}
  represent the result of a cluster analysis on a list of
  clickstreams (see \code{\link{clusterClickstreams}}).}
  \item{pattern}{The first clicks of a user as
  \code{Pattern} object.} \item{...}{Ignored parameters.}
}
\value{
Returns the index of the clusters to which the given
\code{Pattern} object most probably belongs to.
}
\description{
Predicts the cluster for a given \code{Pattern} object.
Potential clusters need to be identified with the method
\code{clusterClickstreams} before predicting the cluster.
}
\examples{
clickstreams <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
csf <- tempfile()
writeLines(clickstreams, csf)
cls <- readClickstreams(csf, header = TRUE)
clusters <- clusterClickstreams(cls, order = 0, centers = 2)
pattern <- new("Pattern", sequence = c("h", "c"))
predict(clusters, pattern)
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
\seealso{
\code{\link{clusterClickstreams}},
\code{\link{print.ClickstreamClusters}}
}

