% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive.R
\name{fix.levels}
\alias{fix.levels}
\title{Fix levels}
\usage{
fix.levels(x, levels = NULL, plot = FALSE,
  k = ifelse(!is.null(levels), length(levels), 2))
}
\arguments{
\item{x}{A factor vector}

\item{levels}{Optional vector with the levels names}

\item{plot}{Optional: Plot cluster dendrogram?}

\item{k}{Number of levels for clustering}
}
\description{
Fixes levels of a factor
}
\examples{
factor1<-factor(c("Control", "Treatment", "Tretament", "Tratment", "treatment",
"teatment", "contrl", "cntrol", "CONTol", "not available", "na"))
fix.levels(factor1, k=4, plot=TRUE)   #Chose k to select matching levels
fix.levels(factor1, levels=c("Control", "Treatment"), k=4)
}
