% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{file_checks}
\alias{file_checks}
\alias{check_file_width}
\alias{check_file_length}
\title{File Checks}
\usage{
check_file_width(path, max_file_width = gco("max_file_width"))

check_file_length(path, max_file_length = gco("max_file_length"))
}
\arguments{
\item{path}{Path to the file to be checked.}

\item{max_file_width}{The maximum line width accepted.
Set (preferably via \code{\link{set_cleanr_options}}) to \code{NULL} or
\code{FALSE} to disable the check.}

\item{max_file_length}{The maximum number of lines accepted.
Set (preferably via \code{\link{set_cleanr_options}}) to \code{NULL} or
\code{FALSE} to disable the check.}
}
\value{
\code{\link[base:invisible]{Invisibly}} \code{\link{TRUE}},
but see \emph{Details}.
}
\description{
A set of tiny functions to check that files adhere to a layout style.
A file should have a clear layout, it should
\itemize{
  \item not have too many lines and
  \item not have lines too wide.
}
}
\details{
In case of a fail all \code{\link{file_checks}} \code{\link{throw}} a
condition of class c("cleanr", "error", "condition").
}
\examples{
print(cleanr::check_file_width(system.file("source", "R", "checks.R",
                                           package = "cleanr")))
print(cleanr::check_file_length(system.file("source", "R", "checks.R",
                                            package = "cleanr"),
                                            max_file_length = 300))
}
