\name{getConfMatr}
\alias{getConfMatr}
\title{
Confusion matrix summarising the performance of an ensemble
}
\description{
The \code{getConfMatr} function returns a confusion matrix from an ensemble created by \code{\link{cfBuild}}. The matrix is populated using class predictions for test data, predictions which were obtained during the building and optimisation of the classifier. Each column of the confusion matrix represents the instances in a predicted class, while each row represents the instances in an actual class. Cells in the matrix indicate the percentage of samples predicted to belong to each class. In a perfect ensemble the diagonal elements would all be 100\%.
}
\usage{
getConfMatr(ensObj)
}
\arguments{
  \item{ensObj}{The classification ensemble (in the form of an R list) as generated by \code{\link{cfBuild}}}
}
\note{
A graphical representation of this information is provided by \code{\link{ggClassPred}}.
}
\examples{
\dontrun{
data(iris)

irisClass <- iris[,5]
irisData  <- iris[,-5]
            
ens <- cfBuild(irisData, irisClass, bootNum = 100, ensNum = 100, parallel = TRUE, 
               cpus = 4, type = "SOCK")

# Get the confusion matrix summarising the performance of the ensemble
getConfMatr(ens)
}
}
\keyword{array}
