% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cladoRcpp.R
\name{rcpp_calc_anclikes_sp_COOweights_faster}
\alias{rcpp_calc_anclikes_sp_COOweights_faster}
\title{Even faster version of rcpp_calc_anclikes_sp}
\usage{
rcpp_calc_anclikes_sp_COOweights_faster(Rcpp_leftprobs, Rcpp_rightprobs, l,
  s = 1, v = 1, j = 0, y = 1, dmat = NULL, maxent01s = NULL,
  maxent01v = NULL, maxent01j = NULL, maxent01y = NULL,
  max_minsize_as_function_of_ancsize = NULL, printmat = TRUE,
  m = NULL, m_null_range = TRUE, jts_matrix = NULL)
}
\arguments{
\item{Rcpp_leftprobs}{Probabilities of the states at the base of the left descendant branch}

\item{Rcpp_rightprobs}{Probabilities of the states at the base of the right descendant branch}

\item{l}{List of state indices (0-based)}

\item{s}{Relative weight of sympatric "subset" speciation. Default \code{s=1} mimics LAGRANGE model.}

\item{v}{Relative weight of vicariant speciation. Default \code{v=1} mimics LAGRANGE model.}

\item{j}{Relative weight of "founder event speciation"/jump speciation. Default \code{j=0} mimics LAGRANGE model.}

\item{y}{Relative weight of fully sympatric speciation (range-copying). Default \code{y=1} mimics LAGRANGE model.}

\item{dmat}{If given, a matrix of rank numareas giving multipliers for the probability
of each dispersal event between areas. Default NULL, which sets every cell of the 
\code{dmat} matrix to value 1.  Users may construct their own parameterized \code{dmat}
(for example, making \code{dmat} a function of distance) for inclusion in ML or
Bayesian analyses.}

\item{maxent01s}{Matrix giving the relative weight of each possible descendant rangesize for 
the smaller range, for a given ancestral rangesize, for a subset-sympatric speciation event. 
Default is \code{NULL}, which means the script will set up the LAGRANGE model (one descendent
always has range size 1).}

\item{maxent01v}{Matrix giving the relative weight of each possible descendant rangesize for 
the smaller range, for a given ancestral rangesize, for a vicariance speciation event. 
Default is \code{NULL}, which means the script will set up the LAGRANGE model (one descendent 
always has range size 1).}

\item{maxent01j}{Matrix giving the relative weight of each possible descendant rangesize for 
the smaller range, for a given ancestral rangesize, for a founder-event speciation event. 
Default is \code{NULL}, which means the script will set up the LAGRANGE model (one descendent 
always has range size 1).}

\item{maxent01y}{Matrix giving the relative weight of each possible descendant rangesize for 
the smaller range, for a given ancestral rangesize, for a full-sympatric (range-copying) 
speciation event. 
Default is \code{NULL}, which means the script will set up the LAGRANGE model (one descendent 
always has range size 1).}

\item{max_minsize_as_function_of_ancsize}{If given, any state with a range larger that this value will 
be given a probability of zero (for the branch with the smaller rangesize).  This means that not every
possible combination of ranges has to be checked, which can get very slow for large state spaces.}

\item{printmat}{Should the probability matrix output be printed to screen? (useful for debugging, but 
can be dramatically slow in R.app for some reason for even moderate numbers of states; perhaps 
overrunning the line length...)}

\item{m}{This is a vector of rate/weight multipliers for dispersal, conditional on the values of some
(non-biogeographical) trait. For example, one might hypothesize that flight/flightlessness effects
dispersal probability, and manually put a multiplier of 0.001 on the flightlessness state. Or, 
one might attempt to estimate this. The strategy used in cladoRcpp is to expand the default cladogenetic
rate matrix by length(m) times. I.e., if \emph{m} is not \code{NULL}, then loop through the values of \emph{m} and apply the 
multipliers to \emph{d} (and \emph{j}, and \emph{a}) events. Default is \code{NULL}.}

\item{m_null_range}{Is the null range included in the state space in the general 
analysis? (The function needs to know this, when there are traits, to index
the state space correctly.)}

\item{jts_matrix}{A numtraits x numtraits matrix containing the proportions for 
trait transitions during j events. E.g., for a sudden switch from 
trait 1 (flight) to trait 2 (flightlessness) during a jump event.}
}
\value{
\code{COO_weights_columnar} Transition weights matrix in COO-like format as 4 columns: 
ancestral index, left index, right index, and weight of the specified transition. Indexes are
0-based. 
Keep in mind that cladogenesis matrices exclude the null state
(a range of 0 areas), so if your states list starts with the 
null range (as is typical/default in DEC-style models)
then to get the R 1-based state indices requires e.g. 
COO_weights_columnar[[1]] + 2.

Dividing the
weights by the sum of the weights for a particular ancestral state yields the conditional
probabilities of each transition at the speciation event.
(assuming likelihood of descendants is 1).
}
\description{
This function improves on \code{\link{rcpp_calc_anclikes_sp}} and
\code{\link{rcpp_calc_anclikes_sp_COOprobs}}.  In addition to the compressed
COO-like storage format, the internal C++ code here explicitly
enumerates the allowed transitions, rather than searching through
every possibility and testing whether or not it is allowed.  This 
appears to scale well to very large state spaces.
}
\details{
This should be faster, i.e. by look for each type of event individually.

Returns results as 4 columns: ancestral index, left index, right index, conditional
probability given ancestral states (assuming likelihood of descendants is 1). Indexes
are 0-based.

Keep in mind that cladogenesis matrices exclude the null state
(a range of 0 areas), so if your states list starts with the 
null range (as is typical/default in DEC-style models)
then to get the R 1-based state indices requires e.g. 
COO_weights_columnar[[1]] + 2.

When the calculation is run at each node in the tree, all that is required is one
pass through the COO-like array, with the downpassed probabilities of the
states on the left and right branches multiplied by the probability column.
}
\examples{
# For the basic logic of a probablistic cladogenesis model, see
?rcpp_calc_anclikes_sp

# For examples of running the functions, see the comparison of all functions at:
# ?cladoRcpp

}
\seealso{
\code{\link{rcpp_calc_anclikes_sp}}, \code{\link{rcpp_calc_anclikes_sp_COOprobs}}, 
\code{\link{rcpp_calc_anclikes_sp_COOweights_faster}}

\code{\link{rcpp_calc_anclikes_sp}}
#bibliography /Dropbox/_njm/__packages/cladoRcpp_setup/cladoRcpp_refs.bib
  @cite Matzke_2013
  @cite Matzke_2014
  @cite ReeSmith2008
}
\author{
Nicholas Matzke \email{matzke@berkeley.edu}
}
