% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ckan_fetch.R
\name{ckan_fetch}
\alias{ckan_fetch}
\title{Download a file}
\usage{
ckan_fetch(x, store = "session", path = "file", format = NULL, ...)
}
\arguments{
\item{x}{URL for the file}

\item{store}{One of session (default) or disk. session stores in R session, and
disk saves the file to disk.}

\item{path}{if store=disk, you must give a path to store file to}

\item{format}{Format of the file. Required if format is not detectable through file URL.}

\item{...}{Curl arguments passed on to \code{\link[httr]{GET}}}
}
\description{
Download a file
}
\examples{
\dontrun{
# CSV file
ckanr_setup("http://datamx.io")
res <- resource_show(id = "6145a539-cbde-4b0d-a3d3-d1a5eb013f5c", as = "table")
head(ckan_fetch(res$url))
ckan_fetch(res$url, "disk", "myfile.csv")

# CSV file, format not available
ckanr_setup("https://ckan0.cf.opendata.inter.sandbox-toronto.ca")
res <- resource_show(id = "75c69a49-8573-4dda-b41a-d312a33b2e05", as = "table")
res$url
res$format
head(ckan_fetch(res$url, format = res$format))

# Excel file - requires readxl package
ckanr_setup("http://datamx.io")
res <- resource_show(id = "e883510e-a082-435c-872a-c5b915857ae1", as = "table")
head(ckan_fetch(res$url))

# XML file - requires xml2 package
ckanr_setup("http://data.ottawa.ca")
res <- resource_show(id = "380061c1-6c46-4da6-a01b-7ab0f49a881e", as = "table")
ckan_fetch(res$url)

# HTML file - requires xml2 package
ckanr_setup("http://open.canada.ca/data/en")
res <- resource_show(id = "80321bac-4283-487c-93bd-c65acaa660f5", as = "table")
ckan_fetch(res$url)
library("xml2")
xml_text(xml_find_first(xml_children(ckan_fetch(res$url))[[1]], "title"))

# JSON file, by default reads in to a data.frame for ease of use
ckanr_setup("http://data.surrey.ca")
res <- resource_show(id = "8d07c662-800d-4977-9e3e-5a3d2d1e99ab", as = "table")
head(ckan_fetch(res$url))

# SHP file (spatial data, ESRI format) - requires sf package
ckanr_setup("https://ckan0.cf.opendata.inter.sandbox-toronto.ca")
res <- resource_show(id = "6cbb0aa3-a8d1-421c-9c40-14c6f05e0c73", as = "table")
x <- ckan_fetch(res$url)
class(x)
plot(x)

# GeoJSON file - requires sf package
ckanr_setup("http://datamx.io")
res <- resource_show(id = "b1cd35b7-479e-4fa0-86e9-e897d3c617e6", as = "table")
x <- ckan_fetch(res$url)
class(x)
plot(x[, c("mun_name", "geometry")])

}
}
