% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_get_kubernetes_instance_configs}
\alias{clusters_get_kubernetes_instance_configs}
\title{Describe an Instance Config}
\usage{
clusters_get_kubernetes_instance_configs(
  instance_config_id,
  include_usage_stats = NULL
)
}
\arguments{
\item{instance_config_id}{integer required. The ID of this instance config.}

\item{include_usage_stats}{boolean optional. When true, usage stats are returned in instance config objects. Defaults to false.}
}
\value{
A list containing the following elements:
\item{instanceConfigId}{integer, The ID of this InstanceConfig.}
\item{instanceType}{string, An EC2 instance type. Possible values include t2.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m5.12xlarge, and p2.xlarge.}
\item{minInstances}{integer, The minimum number of instances of that type in this cluster.}
\item{maxInstances}{integer, The maximum number of instances of that type in this cluster.}
\item{instanceMaxMemory}{integer, The amount of memory (RAM) available to a single instance of that type in megabytes.}
\item{instanceMaxCpu}{integer, The number of processor shares available to a single instance of that type in millicores.}
\item{instanceMaxDisk}{integer, The amount of disk available to a single instance of that type in gigabytes.}
\item{usageStats}{list, A list containing the following elements: 
\itemize{
\item pendingMemoryRequested integer, The sum of memory requests (in MB) for pending deployments in this instance config.
\item pendingCpuRequested integer, The sum of cpu requests (in millicores) for pending deployments in this instance config.
\item runningMemoryRequested integer, The sum of memory requests (in MB) for running deployments in this instance config.
\item runningCpuRequested integer, The sum of cpu requests (in millicores) for running deployments in this instance config.
\item pendingDeployments integer, The number of pending deployments in this instance config.
\item runningDeployments integer, The number of running deployments in this instance config.
}}
}
\description{
Describe an Instance Config
}
