% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{scripts_list}
\alias{scripts_list}
\title{List scripts}
\usage{
scripts_list(type = NULL, category = NULL, author = NULL, status = NULL,
  hidden = NULL, archived = NULL, limit = NULL, page_num = NULL,
  order = NULL, order_dir = NULL)
}
\arguments{
\item{type}{string optional. If specified, return items of these types. The valid types are sql, python3, javascript, r, and containers.}

\item{category}{string optional. A job category for filtering scripts. Must be one of script, import, export, and enhancement.}

\item{author}{string optional. If specified, return items from this author. Must use user IDs. A comma separated list of IDs is also accepted to return items from multiple authors.}

\item{status}{string optional. If specified, returns items with one of these statuses. It accepts a comma-separated list, possible values are 'running', 'failed', 'succeeded', 'idle', 'scheduled'.}

\item{hidden}{boolean optional. If specified to be true, returns hidden items. Defaults to false, returning non-hidden items.}

\item{archived}{string optional. The archival status of the requested item(s).}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, name, created_at, last_run.updated_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID for the script.}
\item{name}{string, The name of the script.}
\item{type}{string, The type of the script (e.g SQL, Container, Python, R, JavaScript)}
\item{createdAt}{string, The time this script was created.}
\item{updatedAt}{string, The time the script was last updated.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The status of the script's last run.}
\item{finishedAt}{string, The time that the script's last run finished.}
\item{projects}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID for the project.
\item name string, The name of the project.
}}
\item{parentId}{integer, The ID of the parent job that will trigger this script}
\item{isTemplate}{boolean, Whether others scripts use this one as a template.}
\item{fromTemplateId}{integer, The ID of the template this script uses, if any.}
\item{links}{list, A list containing the following elements: 
\itemize{
\item details string, The details link to get more information about the script.
\item runs string, The runs link to get the run information list for this script.
}}
\item{timeZone}{string, The time zone of this script.}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{archived}{string, The archival status of the requested item(s).}
\item{templateScriptId}{integer, The ID of the template script, if any.}
}
\description{
List scripts
}
